import py
from py.__.misc import rest
from shared_helpers import is_on_path

def setup_module(mod):
    if not is_on_path("gs") or not is_on_path("dot") or not is_on_path("latex"):
        py.test.skip("ghostscript, graphviz and latex needed")

data = py.magic.autopath().dirpath().join("data")

def test_process_simple():
    # fallback test: only checks that no exception is raised
    def rec(p):
        return p.check(dotfile=0)
    for x in data.visit("*.txt", rec=rec):
        yield rest.process, x

