# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import os
from os.path import join, exists, isdir, isfile, dirname, abspath, expanduser
import logging

# Autotools set the actual data_dir in defs.py
from cohoba.defs import PREFIX, DATA_DIR, LIB_DIR, VERSION, PACKAGE, PYTHONDIR
DATA_DIR = DATA_DIR.replace('${prefix}', PREFIX)
LIB_DIR = LIB_DIR.replace('${prefix}', PREFIX)
PYTHONDIR = PYTHONDIR.replace('${prefix}', PREFIX)


# Allow to use uninstalled deskbar ---------------------------------------------
UNINSTALLED_COHOBA = False
def _check(path):
	return exists(path) and isdir(path) and isfile(path+"/AUTHORS")
	
name = join(dirname(__file__), '..')
if _check(name):
	UNINSTALLED_COHOBA = True
	
# Sets SHARED_DATA_DIR to local copy, or the system location
# Shared data dir is most the time /usr/share/cohoba
if UNINSTALLED_COHOBA:
	SHARED_DATA_DIR = abspath(join(dirname(__file__), '..', 'data'))
else:
	SHARED_DATA_DIR = join(DATA_DIR, "cohoba")
print "Data Dir: %s" % SHARED_DATA_DIR

USER_COHOBA_DIR = expanduser("~/.gnome2/cohoba")
if not exists(USER_COHOBA_DIR):
	try:
		os.makedirs(USER_COHOBA_DIR, 0744)
	except Exception , msg:
		print 'Error:could not create cohoba user dir (%s): %s' % (USER_COHOBA_DIR, msg)
# ------------------------------------------------------------------------------

# Set the cwd to the home directory so spawned processes behave correctly
# when presenting save/open dialogs
os.chdir(expanduser("~"))

# Path to images, icons
ART_DATA_DIR = join(SHARED_DATA_DIR, "art")

COHOBA_APPLET_MODE_MAIN = 0
COHOBA_APPLET_MODE_GROUP = 1
COHOBA_APPLET_MODE_CONTACT = 2
COHOBA_APPLET_MODE_ME = 3

# GConf dir prefix for accounts storage
GCONF_HOUSTON_DIR = "/apps/houston"
GCONF_HOUSTON_ACCOUNTS_DIR = GCONF_HOUSTON_DIR + "/accounts"

GCONF_COHOBA_DIR = "/apps/cohoba"

LOGGING_LEVEL = logging.INFO
