# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import dbus.service

from telepathy.interfaces import CHANNEL_TYPE_TEXT, CHANNEL_HANDLER_INTERFACE

from cohoba.common.Utils import global_error_handler
from cohoba.common.DBusProxyProvider import get_proxy_provider
from cohoba.contacts.Contact import Contact
from cohoba.bigbrother.ConversationLogger import ConversationLogger

class BigBrotherChannelHandler(dbus.service.Object):
	def __init__(self):
		bus_name = 'org.freedesktop.Telepathy.Cohoba.BigBrotherChannelHandler'
		object_path = '/org/freedesktop/Telepathy/Cohoba/BigBrotherChannelHandler'
		dbus.service.Object.__init__(self, dbus.service.BusName(bus_name), object_path)
		
	@dbus.service.method(CHANNEL_HANDLER_INTERFACE, in_signature='sosouu', out_signature='')
	def HandleChannel(self, conn_name, conn_obj, channel_type, chan_obj, handle_type, handle):
		print 'Handle BigBrotherChannelHandler:', conn_name, conn_obj, channel_type, chan_obj, handle_type, handle
		get_proxy_provider().create_proxy(conn_name, conn_obj)
		if channel_type != CHANNEL_TYPE_TEXT:
			print "Error, big brother can't handle anything else than text channels"
			return
		
		ConversationLogger(conn_obj, chan_obj, Contact(conn_obj, handle, False))
