# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import gobject, dbus, os
from os.path import join, exists
from cohoba import USER_COHOBA_DIR
from cohoba.common.Utils import global_error_handler
from cohoba.common.TelepathyConversation import TelepathyConversation

CONVERSATIONS_DIR = join(USER_COHOBA_DIR, "conversations")
if not exists(CONVERSATIONS_DIR):
	try:
		os.makedirs(CONVERSATIONS_DIR, 0744)
	except Exception , msg:
		print 'Error:could not create cohoba conversations dir (%s): %s' % (CONVERSATIONS_DIR, msg)
		
class ConversationLogger(TelepathyConversation):
	def __init__(self, conn_path, obj_path, contact):
		TelepathyConversation.__init__(self, conn_path, obj_path, contact)
		print 'Big Brother is watching you:', conn_path, obj_path
		self.closed = False
		self.contact = contact
		self.log = None
		self.flush_id = 0
		self.flush_msg_count = 0
		self.pending_messages = []
		
		contact.connect('updated', self.check_start_logging)
		
	
	def check_start_logging(self, contact):
		if contact.name != None and self.log == None and not self.closed:
			self.log = file(join(CONVERSATIONS_DIR, contact.name), 'a')
			for message in self.pending_messages:
				self.log_message(*message)
			self.pending_messages = []
		
	def handle_incoming(self, id, timestamp, sender, message_type, flags, message):
		TelepathyConversation.handle_incoming(self, id, timestamp, sender, message_type, flags, message)
		self.log_message(timestamp, self.contact.name, message_type, message)
	
	def handle_outgoing(self, timestamp, message_type, message):
		TelepathyConversation.handle_outgoing(self, timestamp, message_type, message)
		self.log_message(timestamp, "me", message_type, message)
	
	def handle_closed(self):
		TelepathyConversation.handle_closed(self)
		self.closed = True
		if self.log != None:
			self.log.close()
		
	def log_message(self, timestamp, sender, message_type, message):
		if self.log == None:
			self.pending_messages.append((timestamp, sender, message_type, message))
			return
			
		self.log.write("%s\t%s\t%s\t%s\n" % (timestamp, sender, message_type, message))
		self.flush_msg_count += 1
		
		if self.flush_id != 0:
			gobject.source_remove(self.flush_id)
		self.flush_id = gobject.timeout_add(30*1000, self.flush)
		
		if self.flush_msg_count > 5:
			self.flush()
			
	def flush(self):
		gobject.idle_add(self.log.flush)
		self.flush_msg_count = 0
		return False
