import gtk, gobject

class PyListStoreIter:
	def __init__(self, store_iter, return_iter=False):
		self.store_iter = store_iter
		self.return_iter = return_iter
		
	def __iter__(self):
		return self
		
	def next(self):
		if self.return_iter:
			row = self.store_iter.next()
			return row.iter, row[0]
		else:
			return self.store_iter.next()[0]
				
class PyListStore(gtk.ListStore):
	def __init__(self):
		gtk.ListStore.__init__(self, gobject.TYPE_PYOBJECT)
	
	def __iadd__(self, toadd):
		self.append(toadd)
		return self
		
	def __getitem__(self, key):
		row = gtk.ListStore.__getitem__(self, key)
		return row[0]
	
	def append(self, value):
		return gtk.ListStore.append(self, [value])
	
	def __iter__(self):
		return PyListStoreIter(gtk.ListStore.__iter__(self))
			
	def __repr__(self):
		return repr([value for value in self])
	
	def get_iter_for_object(self, obj):
		for iter, o in PyListStoreIter(gtk.ListStore.__iter__(self), True):
			if o == obj:
				return iter
