# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import dbus, dbus.glib
import dbus.service

from cohoba.common.Utils import global_error_handler, SignalConnection
from cohoba.common.DBusProxyProvider import get_proxy_provider
from cohoba.common.TelepathyConstants import (MISSION_CONTROL_BUS_NAME,
	MISSION_CONTROL_OBJECT_PATH,
	MISSION_CONTROL_INTERFACE)
from cohoba.contacts.MergedContactList import get_contact_list

from telepathy.constants import CONNECTION_HANDLE_TYPE_LIST
from telepathy.interfaces import CONN_INTERFACE, CHANNEL_TYPE_CONTACT_LIST

class ContactListChannelHandler:	
	def __init__(self):		
		get_proxy_provider().create_proxy(
			MISSION_CONTROL_BUS_NAME, MISSION_CONTROL_OBJECT_PATH)

		self.mission_control_iface = get_proxy_provider().get_iface(
			MISSION_CONTROL_OBJECT_PATH, MISSION_CONTROL_INTERFACE)

		print 'Ask for connected accounts'
		self.mission_control_iface.GetConnectedAccounts(reply_handler=self.got_connected_accounts_fake, error_handler=global_error_handler)

	def on_account_connected(self, bus_name, obj_path):
		print 'New account connected'
		self.request_subscribe_list(bus_name, obj_path)
	
	def got_connected_accounts_fake(self, accounts):
		# FIXME: Horrible hack, really racy, should be put before GetConnectedAccounts, but then it requires activation to work. You can't connect a signal to a non-activated service.
		self.__AccountConnected_conn = SignalConnection(self.mission_control_iface, 'AccountConnected', self.on_account_connected)
		self.mission_control_iface.GetConnectedAccounts(reply_handler=self.got_connected_accounts, error_handler=global_error_handler)

	def got_connected_accounts(self, accounts):
		for conn_name, conn_obj, profile, description, username in accounts:
			self.request_subscribe_list(conn_name, conn_obj)
	
	def request_subscribe_list(self, conn_name, conn_obj):
		get_proxy_provider().create_proxy(conn_name, conn_obj)
		conn_iface = get_proxy_provider().get_iface(conn_obj, CONN_INTERFACE)
		print "Requesting handles: LIST 'subscribe'"
		conn_iface.RequestHandles(CONNECTION_HANDLE_TYPE_LIST, ["subscribe"],
			reply_handler=lambda handles: self.got_subscribe_handle(conn_obj, handles),
			error_handler=global_error_handler)
		
	def got_subscribe_handle(self, conn_obj, handles):
		assert len(handles) == 1
		handle = handles[0]
		conn_name = get_proxy_provider().get_service(conn_obj)
		conn_iface = get_proxy_provider().get_iface(conn_obj, CONN_INTERFACE)
		conn_iface.RequestChannel(
			CHANNEL_TYPE_CONTACT_LIST,
			CONNECTION_HANDLE_TYPE_LIST,
			handle,
			True,
			reply_handler=lambda chan_obj: self.got_channel(conn_name, conn_obj, chan_obj, handle),
			error_handler=global_error_handler)
	
	def got_channel(self, conn_name, conn_obj, chan_obj, handle):
		print 'Handle Contact list:', conn_name, conn_obj, chan_obj, handle
		get_proxy_provider().create_proxy(conn_name, conn_obj)
		get_contact_list().add_telepathy_group(conn_obj, chan_obj, handle)	
