import gtk
import gtk.glade
from os.path import join
import cohoba
	
class ContactListWindow(gtk.Window):
	def __init__(self, group):
		gtk.Window.__init__(self)
		self.set_property("border_width", 12)
		self.set_property("window_position", gtk.WIN_POS_CENTER)
  
		glade = gtk.glade.XML(join(cohoba.SHARED_DATA_DIR, "main.glade"), "contents")
		# Glade Widgets
		self.add(glade.get_widget("contents"))

		from cohoba.contacts.ui.ContactListView import ContactListView		
		self.view = ContactListView(group)
		self.view.show()
		glade.get_widget("contactlistscroll").add(self.view)
		
		self.name_label = glade.get_widget("name")
		self.groups_label = glade.get_widget("groups")
		
		self.set_title(group.name)
		
		# Widgets signals
		self.connect('delete-event', self.on_window_delete)
		
		self.name_label.set_markup("<span size='large' weight='ultrabold'>%s</span>" % group.name)
		self.groups_label.set_markup("<span size='small'>%s</span>" % str(group.groups))
		
	def on_window_delete(self, win, event):
		self.hide()
		return True
