# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import gobject

from cohoba.common.Utils import global_error_handler
from cohoba.common.TelepathyGroup import TelepathyGroup

TELEPATHY_VOIP_GROUP_TYPE_UNKOWN = 0
TELEPATHY_VOIP_GROUP_TYPE_INCOMING = 1
TELEPATHY_VOIP_GROUP_TYPE_OUTGOING = 2

TELEPATHY_VOIP_GROUP_STATE_STARTING = 0
TELEPATHY_VOIP_GROUP_STATE_CALLING = 1
TELEPATHY_VOIP_GROUP_STATE_WAITING_ACCEPT = 2
TELEPATHY_VOIP_GROUP_STATE_TALKING = 3
TELEPATHY_VOIP_GROUP_STATE_CLOSING = 4
TELEPATHY_VOIP_GROUP_STATE_CLOSED  = 5

class TelepathyVoipGroup(TelepathyGroup, gobject.GObject):
	__gsignals__ = {
		"updated": (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, []),
		"need-authorization": (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [])
	}
	
	def __init__(self, conn_obj, chan_obj):
		TelepathyGroup.__init__(self, conn_obj, chan_obj, 0)
		gobject.GObject.__init__(self)
		
		self.call_type = TELEPATHY_VOIP_GROUP_TYPE_UNKOWN
		self.state = TELEPATHY_VOIP_GROUP_STATE_STARTING
		self.other_handle = None
	
	def accept(self):
		self.add_member(self.get_local_members()[0].handle)
	
	def stop(self):
		print 'Stop voip:', self.chan_iface
		self.chan_iface.Close(reply_handler=lambda: None, error_handler=global_error_handler)
	
	def _channel_closed(self):
		self.state = TELEPATHY_VOIP_GROUP_STATE_CLOSED
		self.emit('updated')
	
	def _flags_changed(self):
		pass
	
	def _members_changed(self):
		print 'Members changed:', [self._member_for_data(self.members[handle]) for handle in self.members.keys()]
		
		TelepathyGroup._members_changed(self)
		
		members = self.get_members()
		local = self.get_local_members()
		remote = self.get_remote_members()
		
		if len(self.members) != 2:
			self.state = TELEPATHY_VOIP_GROUP_STATE_CLOSING
		elif len(members) == 2:
			self.state = TELEPATHY_VOIP_GROUP_STATE_TALKING
		elif len(local) == 1:
			self.state = TELEPATHY_VOIP_GROUP_STATE_WAITING_ACCEPT
			self.call_type = TELEPATHY_VOIP_GROUP_TYPE_INCOMING
		elif len(remote) == 1:
			self.state = TELEPATHY_VOIP_GROUP_STATE_CALLING
			self.call_type = TELEPATHY_VOIP_GROUP_TYPE_OUTGOING
		
		if self.handle in self.members:
			other = [handle for handle in self.members.keys() if handle != self.handle]
			print 'Other:', other
			if len(other) == 1:
				self.other_handle = other[0]
			
		self.emit('updated')
	
	def __repr__(self):
		return "TelepathyVoipGroup(%s, %s)" % (self.state, self.call_type)
		
	# group+local/remote
	# Incoming Call
	#  other+me/-
	# Outgoing Call
	#  me+-/other
