unit UDes;
{Collatinus - Extraction du lexique d'un texte latin.

Copyright (C) 1998 Y. Ouvrard.

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec l'auteur : yves.ouvrard@collatinus.org }

{$MODE DELPHI}

interface
Uses Classes;

Type
  TDef = Class(TObject)
    Modele,
    RadicalNumero : integer;
    Flags : cardinal;//integer;
    Constructor Create(M, RN : integer; Fl : cardinal);
      // Modle, RadicalNumro, Flags
    Constructor Lis(R : TReader);
    Procedure Ecris(W : TWriter);
    private
     Function GetCategorie : integer;
     Function GetCasus : cardinal;
     Function GetGenus : cardinal;
     Function GetNumerus : cardinal;
     Function GetModus : cardinal;
     Function GetTempus : cardinal;
     Function GetPersona : cardinal;
     Function GetVox : cardinal;
     Function GetGradus : cardinal;
    procedure SetCasus(const Value: cardinal);
    procedure SetGenus(const Value: cardinal);
    procedure SetGradus(const Value: cardinal);
    procedure SetModus(const Value: cardinal);
    procedure SetNumerus(const Value: cardinal);
    procedure SetPersona(const Value: cardinal);
    procedure SetTempus(const Value: cardinal);
    procedure SetVox(const Value: cardinal);
    public
     property Categorie : integer read GetCategorie;
     property Casus : cardinal read GetCasus write SetCasus;
     property Genus: cardinal read GetGenus write SetGenus;
     property Numerus: cardinal read GetNumerus write SetNumerus;
     property Modus: cardinal read GetModus write SetModus;
     property Tempus: cardinal read GetTempus write SetTempus;
     property Persona: cardinal read GetPersona write SetPersona;
     property Vox: cardinal read GetVox write SetVox;
     property Gradus: cardinal read GetGradus write SetGradus;
     Function Graphie ( Complete : Boolean) : string;
    end;

  TListeDes = Class(TStringList)
  private
    function Getgraphie(LeModele : integer; G,M,T,V,D : cardinal): TstringList;
    procedure Setgraphie(LeModele : integer; G,M,T,V,D : cardinal;
      const Value: TstringList);
  public
    Constructor Lis(R : TReader);
    Constructor Lis_xml;
    Procedure Ecris(W : TWriter);
    Procedure EcrisListe(N : integer ; W : TWriter);
    Procedure Ajoute(
      D : string ;
      M, RN : integer; Fl : cardinal);
    Function Definitions(N : integer) : TList;
    Function Definition(N, D : integer) : TDef;
    property graphie[LeModele : integer; G,M, T, V, D : cardinal]: TstringList
       read Getgraphie write Setgraphie;
  end;

Const
// noms

  // Cas
  Cas : array[0..5] of cardinal = ($01, $02, $04, $08, $10, $20);
  totalCas : cardinal = ($01 or $02 or $04 or $08 or $10 or $20);

  // Nombres
  Nombres : Array[0..1] of cardinal = ($40, $80);
  totalNombres : cardinal = ($40 or $80);

  // Genres
  Genres : Array[0..2] of cardinal = ($100, $200, $400);
  totalGenres : cardinal = ($100 or $200 or $400);

  // personnes
  Personnes : Array[0..2] of cardinal =
    ($800, $1000, $2000);
  TotalPersonnes : cardinal = ($800 or $1000 or $2000);

  // temps
  Temps : Array[0..5] of cardinal =
    ($4000, $8000, $10000, $20000, $40000, $80000);
  totalTemps : cardinal =
  ($4000 or $8000 or $10000 or $20000 or $40000 or $80000);


  // modes
  Modes : Array[0..6] of cardinal =
    ($100000, $200000, $400000, $800000, $1000000, $2000000, $4000000);
  TotalModes : cardinal =
    ($100000 or $200000 or $400000 or $800000 or $1000000 or $2000000 or $4000000);

  // voix
  Voix : Array[0..1] of cardinal = ($8000000, $10000000);
  TotalVoix : cardinal = ($8000000 or $10000000);

  // degr (ajout en novembre mmi)
  Degres : Array[0..2] of cardinal = ($20000000, $40000000, $80000000);
  TotalDegres : cardinal = $20000000 or $40000000 or $80000000;

var
  Desinences : TListeDes;

implementation
uses SysUtils, ulistes, utiles, token, Crt;

{ TDef }

Constructor TDef.Create(M, RN : integer; Fl : cardinal);
Begin
Inherited Create;
   Modele := M;
   RadicalNumero := RN ;
   Flags := Fl;
end;

Constructor TDef.Lis(R : TReader);
Begin
Modele := R.ReadInteger;
RadicalNumero := R.ReadInteger;
Flags := R.ReadInteger;
end;

Procedure TDef.Ecris(W : TWriter);
Begin
W.WriteInteger(Modele);
W.WriteInteger(RadicalNumero);
W.WriteInteger(Flags);
end;

Function TDef.GetCategorie : integer;
Begin
Case Modele of
    0..10 : result := 0 ; // nom
    11..16 : result := 1 ;// adj
    17..28 : result := 3; // verbe
    29 : result := 2 ;  // pronom
    30 : result := 4 ; // inv.
    else result := -1;
    end;
end;

Function TDef.GetCasus : cardinal;
var i : cardinal;
Begin
result := -1;
for i := 0 to 5 do
  if Flags and cas[i] > 0
  then
  if result = 0 then result := i
    else result := result or i;
end;

Function TDef.GetGenus : cardinal;
var i : cardinal;
Begin
result := -1;
for i := 0 to 2 do
  if Flags and Genres[i] > 0
  then result := i;
end;

Function TDef.GetNumerus : cardinal;
var i : integer;
Begin
result := -1;
for i := 0 to 1 do
  if Flags and Nombres[i] > 0
  then result := i;
end;

Function TDef.GetModus : cardinal;
var i : integer;
Begin
result := -1;
for i := 0 to 6 do
  if Flags and Modes[i] > 0
  then result := i;
end;

Function TDef.GetTempus : cardinal;
var i : integer;
Begin
result := -1;
for i := 0 to 5 do
  if Flags and Temps[i] > 0
  then result := i;
end;

Function TDef.GetPersona : cardinal;
var i : integer;
Begin
result := -1;
for i := 0 to 2 do
  if Flags and Personnes[i] > 0
  then result := i;
end;


Function TDef.GetVox : cardinal;
var i : integer;
Begin
result := -1;
for i := 0 to 1 do
  if Flags and Voix[i] > 0
  then result := i;
end;

Function TDef.Graphie ( Complete : Boolean) : String;
var i : integer;
Begin
Result := '';
// personne
for i := 0 to 2 do
  if Flags and personnes[i] > 0
  then result := result + ' '+listePersonnes[i];
// cas
for i := 0 to 5 do
  if Flags and cas[i] > 0
  then result := listeCas[i];
// genre
For i := 0 to 2 do
  if Flags and Genres[i] > 0
  then result := result+' '+ListeGenres[i];
// nombre
for i := 0 to 1 do
  if Flags and nombres[i] > 0
  then result := result+' '+listeNombres[i];
// mode
for i := 0 to 6 do
  if flags and modes[i] > 0
  then result := result+' '+listeModes[i];
// temps
for i := 0 to 5 do
  if flags and temps[i] > 0
  then result := result+' '+listeTemps[i];
// voix
for i := 0 to 1 do
  if flags and voix[i] > 0
  then result := result + ' ' + listeVoix[i];
// degr
for i := 0 to 2 do
   if flags and degres[i] > 0
      then result := result + ' ' + ListeDegres[i];
// modle et radical
if Complete then
  result := result + ' modle '+ListeModeles[modele]+
                   ' radical '+inttoStr(radicalNumero);
end;

function TDef.GetGradus: cardinal;
   var i : integer;
begin
   Result :=  0;
   for i := 0 to 2 do
     if Flags and Degres[i] > 0
     then result := i;
end;

procedure TDef.SetCasus(const Value: cardinal);
begin
   Flags := Flags and not TotalCas;
   Flags := Flags or Value;
end;

procedure TDef.SetGenus(const Value: cardinal);
begin
   Flags := Flags and not TotalGenres; 
   Flags := Flags or Value;
end;

procedure TDef.SetGradus(const Value: cardinal);
begin
   Flags := Flags and not TotalDegres;
   Flags := Flags or Value;
end;

procedure TDef.SetModus(const Value: cardinal);
begin
   Flags := Flags and not TotalModes;
   Flags := Flags or Value;
end;

procedure TDef.SetNumerus(const Value: cardinal);
begin
   Flags := Flags and not TotalNombres;
   Flags := Flags or Value;
end;

procedure TDef.SetPersona(const Value: cardinal);
begin
   Flags := Flags and not TotalPersonnes;
   Flags := Flags or Value;
end;

procedure TDef.SetTempus(const Value: cardinal);
begin                      
   Flags := Flags and not TotalTemps;
   Flags := Flags or Value;
end;

procedure TDef.SetVox(const Value: cardinal);
begin 
   Flags := Flags and not TotalVoix;
   Flags := Flags or Value;
end;

{ TListeDes }
 
Constructor TListeDes.Lis(R : TReader);
var i, idef  : integer;
    l : TList;
    ChDes : String;
Begin
inherited Create;
Sorted := true;
Duplicates := dupError;
// lecture;
i := R.ReadInteger;
While i > 0 do
  begin
  ChDes := R.ReadString;
  l := TList.Create;
  idef := R.ReadInteger;
  while idef > 0 do
    begin
    l.Add(TDef.lis(R));
    dec(idef);
    end;
  AddObject(ChDes, l);
  dec(i);
  end;
end;

Constructor TListeDes.Lis_xml;
var
   liste : TStringList;
   chemin : string;
   // points : integer;
   i : integer;
   gr : string;
   c,n,g,p,t,m,v : integer;
   modl,r : integer;
   Fl : cardinal;  
const
   roue = '|/-\';

   function debaliser(b, l : string) : string;
   var
      len : integer;
      p : integer;
   begin
      len := length (b);
      p := pos('<' + b + '>', l) + len + 2;
      result := copy (l, p, length(l));
      p := pos ('</' + b, result) - 1;
      result := copy (result, 1, p);
   end;

begin
   // lecture  partir du fichier desinences.xml.
   inherited Create;
   Sorted := true;
   duplicates := DupError;
   liste := TStringList.Create;
   if fileexists (share + 'desinences.xml')
      then chemin := share
   else chemin := extractFilePath(Paramstr(0));
   writeln ('lecture des dsinences en ' + chemin);
   liste.LoadFromFile (chemin + 'desinences.xml');
   // liminer l''en-tte
   i := 0;
   while pos('<collatinus>', liste[i]) < 1
     do inc (i);
   inc (i);
   // 'points' est le compteur
   // points := 0;
   c:=0;g:=0;g:=0;n:=0;p:=0;t:=0;v:=0;
   while pos('</collatinus>', liste[i]) < 1 do
      begin
         if pos ('<graphie>', liste[i]) > 0
            then gr := rebours(debaliser('graphie', liste[i]))
         else if pos ('<cas>', liste[i]) > 0
            then c := StrToInt (debaliser ('cas', liste[i]))
         else if pos ('<nombre>', liste[i]) > 0
            then n := StrToInt (debaliser ('nombre', liste[i]))
         else if pos ('<genre>', liste[i]) > 0
            then g := StrToInt (debaliser ('genre', liste[i]))
         else if pos ('<personne>', liste[i]) > 0
            then p := StrToInt (debaliser ('personne', liste[i]))
         else if pos ('<temps>', liste[i]) > 0
            then t := StrToInt (debaliser ('temps', liste[i]))
         else if pos ('<mode>', liste[i]) > 0
            then m := StrToInt (debaliser ('mode', liste[i]))
         else if pos ('<voix>', liste[i]) > 0
            then v := StrToInt (debaliser ('voix', liste[i]))
         else if pos ('<modele>', liste[i]) > 0
            then modl := StrToInt (debaliser ('modele', liste[i]))
         else if pos ('<R>', liste[i]) > 0
            then r := StrToInt (debaliser ('R', liste[i]))
         else if pos ('</desinence>', liste[i]) > 0 then
            begin
               Fl := 0;
               if c > 0 then Fl := Cas[c - 1];
               if g > 0 then Fl := Fl or Genres[g-1];
               if n > 0 then Fl := Fl or Nombres[n-1];
               if m > 0 then Fl := fl or Modes[m-1];
               if p > 0 then Fl := Fl or Personnes[p-1];
               if t > 0 then Fl := Fl or Temps[t-1];
               if v > 0 then Fl := Fl or Voix[v-1];
               ajoute (gr, modl, r, Fl);
	       c:=0;g:=0;g:=0;n:=0;p:=0;t:=0;v:=0;
	       {// code  dcommenter pour avoir un signal de chargement
               inc (points); 
               if points mod 100 = 0 then
                  begin
                     GotoXY(2,WhereY);
                     ClrEol;
                     write(roue[1+((points div 100) mod 4)]);
                  end;}
            end;
        inc (i);
     end;
   liste.free;
end;

Procedure TListeDes.Ecris(W : TWriter);
var i : integer;
Begin
W.WriteInteger(Count);
For i := 0 to count - 1 do EcrisListe(i, W);
end;


Procedure TListeDes.EcrisListe(N : integer ; W : TWriter);
var i : integer;
Begin
W.WriteString(Strings[N]);
W.WriteInteger(Definitions(N).count);
for i := 0 to Definitions(N).count-1 do
  Definition(N, i).Ecris(W);
end;

Function TListeDes.Definitions(N : integer) : TList;
Begin
   Result := TList(Objects[N]);
end;


Function TListeDes.Definition(N, D : integer) : TDef;
Begin
Result := TDef(Definitions(N)[D]);
end;

Procedure TListeDes.Ajoute(
  D : string ;
  M, RN : integer;
  Fl : cardinal);
var p, i : integer;
    l : TList;
Begin
// writeln ('ajout du flag ', inttostr(Fl));
if not Find(D, p) then
  begin
  l := TList.Create;
  l.add(TDef.Create(M, RN, Fl));
  addObject(D, l);
  end
  else
  begin
  For i := 0 to definitions(p).count -1 do
    if (Definition(p, i).Flags = Fl) and
       (Definition(p, i).modele = M) and
       (Definition(p, i).radicalNumero = RN) then exit;
  TList(Objects[p]).Add(TDef.Create(M, RN, Fl));
  end;
end;

function TListeDes.Getgraphie(LeModele : integer;
  G,M,T,V,D : cardinal): TstringList;
var
  iDes, iDef, max : integer;

  function ajoute(l : string; d : string) : string;
  begin
  if (l = '-')
     then result := d
     else result := l + ',' + d;
  end;
begin
   { renvoie la dsinence de modle, cas, genre, nombre, mode, temps,
     voix et degr demands }
result := TStringList.Create;
// calculer la longueur de la liste
max := 0;
Case LeModele of
   0..16 : max := 11; // noms et adj.
   17..28 :
      case M of
        0..2, 5 : max := 5;
        3 : max := 0;
        else max := 11;
        end;
   end;
for iDes := 0 to max do result.Add('-');
for iDes := 0 to count - 1 do
   for iDef := 0 to Definitions(iDes).Count - 1 do
      with Definition(iDes, iDef) do
         if (modele = LeModele) and (Genus = G) and (Tempus = T)
            and (Modus = M) and (Vox = V) and (Gradus = D)
            then case categorie of
               0, 1 : // nom, adjectif
                  result[casus + (numerus * 6)] :=
                  ajoute (result[casus + (numerus * 6)], rebours(strings[iDes]));
               3 : // verbe
                    case M of
                       0..2 : result[persona + (numerus * 3)] :=
                          ajoute(result[persona + (numerus * 3)], rebours(strings[iDes]));
                       3 : result[0] :=
                          ajoute(result[0], rebours(strings[iDes])); // infinitif
                       4.. 6 :
                          result[casus + (numerus * 6)] :=
                          ajoute (result[casus + (numerus * 6)], rebours(strings[iDes]));
                       end;
               end;
end;

procedure TListeDes.Setgraphie(LeModele : integer; G,M,T,V,D : cardinal;
      const Value: TstringList);
var
   iDes, iDef, iLigne, iAtome, R : integer;
                            // R = radical numro...
   function verif(l : string) : string;
   begin
   result := trim(l);
   if l[1] = '-'
      then result := '';
   end;
begin
// lit les dsinences et les intgre  la base.
// 1. supprimer de la base toutes les dfinitions correspondant  la morpho
for iDes := 0 to count - 1 do
   begin
       iDef := 0;
       while iDef < Definitions(iDes).count do
          with Definition(iDes, iDef) do
             if (modele = LeModele)
                and (genus = G)
                and (modus = M)
                and (tempus = T)
                and (vox = V)
                and (gradus = D)
                then Definitions(iDes).Delete(iDef)
             else inc(iDef);
   end;
// 2. ajouter les dfinitions de Value en tenant compte des ds. multiples.
case leModele of
   0..10 : // nom
      for iLigne := 0 to 11 do
         begin
           Value[iLigne] := verif(Value[iLigne]);
           if (Value[iLigne] > '') then
               begin
                  for iAtome := 1 to NumToken(Value[iLigne], ',') do
                     begin
                        Ajoute(
                          rebours(trim(GetToken(Value[iLigne], ',', iAtome))),
                          leModele,
                          1, // numro de radical
                          cas[iLigne mod 6]   // sing/plur !
                            or nombres[iLigne div 6]
                          );
                     end;
               end;
         end;
   11..16 : // adjectif : + genre + degr
      for iLigne := 0 to 11 do
         begin
           Value[iLigne] := verif(Value[iLigne]);
           if (Value[iLigne] > '') then
               begin
                  for iAtome := 1 to NumToken(Value[iLigne], ',') do
                     begin
                        Ajoute(
                          rebours(trim(GetToken(Value[iLigne], ',', iAtome))),
                          leModele,
                          1, // numro de radical
                          cas[iLigne mod 6]   // sing/plur !
                            or nombres[iLigne div 6]
                            or genres[G]
                            or degres[D]
                          );
                     end;
               end;
         end;
   17..28 : // verbe : tenir compte des formes dclines
      case M of
         0..2 : // modes conjugus.
            begin
              // radical
              if (T < 3) or (leModele = 17)
                 then R := 1   // infectum
                 else R := 2;  // perfectum
              for iLigne := 0 to 5 do
                 begin
                    Value[iLigne] := verif(Value[iLigne]);
                    if (Value[iLigne] > '') then
                       for iAtome := 1 to NumToken(Value[iLigne], ',') do
                          Ajoute(
                             rebours(trim(GetToken(Value[iLigne], ',', iAtome))),
                             leModele,
                             R, // numro de radical
                             personnes[iLigne mod 3]   // sing/plur !
                               or nombres[iLigne div 3]
                               or temps[T]
                               or modes[M]
                               or Voix[V]);
                 end;
            end;
         3 : // infinitif
            begin
              Value[0] := verif(Value[0]);
              if leModele = 17 then R := 1
              else case T of
                 0 : R := 1;  // prsent
                 3 : R := 2; // parfait
                 else R := 3; // futur
                 end;
              for iAtome := 1 to NumToken(Value[0], ',') do
                 Ajoute(
                     rebours(trim(GetToken(Value[0], ',', iAtome))),
                        leModele,
                        R, // numro de radical
                        temps[T]
                          or modes[M]
                          or Voix[V]);
            end;
         4, 6 : // modes dclins
            begin
               if leModele = 17 then R := 1
               else case T of
                   0 : R := 1;  // prsent
                   // 3 : R := 2; // parfait (bogue corrig le 4 aot 2002)
                   else R := 3; // parfait, futur
                   end;
                for iLigne := 0 to 11 do
                   begin
                     Value[iLigne] := verif(Value[iLigne]);
                     if (Value[iLigne] > '') then
                         begin
                            for iAtome := 1 to NumToken(Value[iLigne], ',') do
                               begin
                                  Ajoute(
                                    rebours(trim(GetToken(Value[iLigne], ',', iAtome))),
                                    leModele,
                                    R, // numro de radical
                                    cas[iLigne mod 6]   // sing/plur !
                                      or nombres[iLigne div 6]
                                      or genres[G]
                                      or modes[M]
                                      or temps[T]
                                      or voix[V]
                                    );
                               end;
                         end;
                 end;
             end;
         5 : // grondif
            for iLigne := 0 to 5 do
               begin
                  Value[iLigne] := verif(Value[iLigne]);
                  if (Value[iLigne] > '') then
                     for iAtome := 1 to NumToken(Value[iLigne], ',') do
                        Ajoute(
                           rebours(trim(GetToken(Value[iLigne], ',', iAtome))),
                           leModele,
                           1, // numro de radical
                           cas[iLigne mod 6]
                           or modes[M]);
               end;
         end;
      end;
end;

end.
