/**
 *
 * Beryl 3d plugin
 *
 * 3d.c
 *
 * Copyright : (C) 2006 by Roi Cohen
 * E-mail    : roico12@gmail.com
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 **/


/**
TODO:
	1. Change windowIs3D.
	2. Clean.
	3. Things done in tdPreparePaintScreen should be done only when needed...
	4. Make settings for this plugin, its just changing the spacing of the windows (SPACE) and the speed of zooming (STEP).
	5. Fix bugs:	1. Non-Maximized windows can't take focus from maximized windows.
			2. Gnome-Panel is drawn last. It also happened in switcher but it was fixed, i'll see how they fixed it there later...
			3. Windows are breaking when they are in more than 1 viewport. This one will be very hard to fix... =\
			4. Decorations not always zooming correctly.
			5. The plugin works much better with the benchmark plugin.	
*/

#include <compiz.h>
#include <stdlib.h>

static int displayPrivateIndex;

typedef struct _tdDisplay {
	int screenPrivateIndex;
	//HandleEventProc handleEvent;
} tdDisplay;

typedef struct _tdScreen {
	int windowPrivateIndex;
	
	Bool transformed;
	
	PreparePaintScreenProc preparePaintScreen;
	
	PaintTransformedScreenProc paintTransformedScreen;
	PaintScreenProc paintScreen;
	
	DonePaintScreenProc donePaintScreen;
	
	PaintWindowProc paintWindow;
} tdScreen;

typedef struct _tdWindow {
	/*struct _tdWindow** next;	//No, its not a typo :) Each window can have more than one next window.
					//It happens if the window is in more than one viewport.
					//If the window is in 2 different viewports, it could have 2 next windows, etc.
	struct _tdWindow* prev;
	
	int i;*/
	
	float z;
	float currentZ;
} tdWindow;

#define STEP 0.03f
#define SPACE 0.02f

#define GET_TD_DISPLAY(d)	\
	((tdDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define TD_DISPLAY(d)	\
	tdDisplay *tdd = GET_TD_DISPLAY (d)

#define GET_TD_SCREEN(s, tdd)	\
	((tdScreen *) (s)->privates[(tdd)->screenPrivateIndex].ptr)

#define TD_SCREEN(s)	\
	tdScreen *tds = GET_TD_SCREEN (s, GET_TD_DISPLAY (s->display))
	
#define GET_TD_WINDOW(w, tds)					  \
	((tdWindow *) (w)->privates[(tds)->windowPrivateIndex].ptr)

#define TD_WINDOW(w)	\
	tdWindow *tdw = GET_TD_WINDOW  (w,		       \
		GET_TD_SCREEN  (w->screen,	       \
			GET_TD_DISPLAY (w->screen->display)))

#define NUM_OPTIONS(s) (sizeof ((s)->opt) / sizeof (CompOption))

static Bool
windowIs3D(CompWindow* w)
{
	if(w->attrib.override_redirect)
		return FALSE;
		
	if(!(w->shaded || w->attrib.map_state == IsViewable))
		return FALSE;
	
	switch(getWindowType(w->screen->display, w->id))
	{
		case CompWindowTypeDialogMask:
		case CompWindowTypeModalDialogMask:
		case CompWindowTypeUtilMask:
		case CompWindowTypeNormalMask:
			return TRUE;
	}
	
	return FALSE;
}

#define VIEWPORT(x, s) ( ( ( ((x>=0)?x: x + s->hsize * s->width) ) / s->width) % (s->hsize) + 1)

#define RIGHT_VIEWPORT(w) VIEWPORT(w->attrib.x + w->attrib.width, w->screen)
#define LEFT_VIEWPORT(w) VIEWPORT(w->attrib.x, w->screen)

/*static Bool
isInSameViewport(CompWindow* w1, CompWindow* w2)
{
	CompWindow* left = (w1->attrib.x < w2->attrib.x)? w1: w2;
	CompWindow* right = (w1->attrib.x > w2->attrib.x)? w1: w2;
	
	if(left->attrib.x + left->attrib.width > right->attrib.x)	//The left window passes the right one.
		return TRUE;
	
	if(RIGHT_VIEWPORT(left) == LEFT_VIEWPORT(right))
		return TRUE;
		
	if(LEFT_VIEWPORT(left) == RIGHT_VIEWPORT(right))	//For the case that the right window is in the last viewport.
		return TRUE;
	
	return FALSE;
}

static void
tdMoveWindowNotify (CompWindow* w,
			int      dx,
			int      dy,
			Bool     immediate)
{
	int leaveViewport=-1, enterViewport=-1;

	if(!windowIs3D(w));
	{
		//ADD UNWRAP-WRAP here
	
		return;
	}
	
	if(dx > 0)	//Window moved to the right.
	{
		if(RIGHT_VIEWPORT(w) != VIEWPORT(w->attrib.x + w->attrib.width - dx, w->screen))	//Window entered to the right viewport.
			enterViewport = RIGHT_VIEWPORT(w);
		
		if(LEFT_VIEWPORT(w) != VIEWPORT(w->attrib.x - dx, w->screen))	//Window has left the left viewport.
			leaveViewport = LEFT_VIEWPRT(w);
	}
	
	else if(dx < 0)	//Window moved to the left.
	{
		if(RIGHT_VIEWPORT(w) != VIEWPORT(w->attrib.x + w->attrib.width - dx, w->screen))	//Window has left to the right viewport.
			leaveViewport = RIGHT_VIEWPORT(w);
		
		if(LEFT_VIEWPORT(w) != VIEWPORT(w->attrib.x - dx, w->screen))	//Window entered the left viewport.
			enterViewport = LEFT_VIEWPRT(w);
	}
	
	if(leaveViewport != -1)
	{
	}
	
	if(enterViewport != -1)
	{
	}
}

static void
tdWindowResizeNotify (CompWindow* w)
{
}*/

static void
tdPreparePaintScreen(CompScreen *screen, int msSinceLastPaint)
{
	tdWindow** lastInViewport;
	
	CompWindow* w;
	tdWindow* tdw;
	
	int i;
	
	float maxZoom;
	
	TD_SCREEN(screen);
	
	if(!tds->transformed)
	{
		UNWRAP(tds, screen, preparePaintScreen);
		(*screen->preparePaintScreen) (screen, msSinceLastPaint);
		WRAP(tds, screen, preparePaintScreen, tdPreparePaintScreen);
		
		return;
	}
	
	lastInViewport = (tdWindow**) malloc(sizeof(tdWindow*) * screen->hsize);

	for(i=0; i<screen->hsize; i++)
		lastInViewport[i] = NULL;

	for(w = screen->windows; w; w = w->next)
	{
		if(!windowIs3D(w))
			continue;

		tdw = GET_TD_WINDOW(w, tds);
		maxZoom = 0.0f;
		
		for(i=0; i<screen->hsize; i++)
		{

			if( ( LEFT_VIEWPORT(w) > RIGHT_VIEWPORT(w) && !(LEFT_VIEWPORT(w) < i + 1 && i + 1 < RIGHT_VIEWPORT(w)) )
				|| ( LEFT_VIEWPORT(w) <= i + 1 && i + 1 <= RIGHT_VIEWPORT(w) ) )
			{
				if( lastInViewport[i] && lastInViewport[i]->z > maxZoom )
					maxZoom = lastInViewport[i]->z;
					
				lastInViewport[i] = tdw;
			}	
		}
		
		tdw->z = maxZoom + SPACE;
	}
	
	UNWRAP(tds, screen, preparePaintScreen);
	(*screen->preparePaintScreen) (screen, msSinceLastPaint);
	WRAP(tds, screen, preparePaintScreen, tdPreparePaintScreen);
}

static Bool
tdPaintWindow (CompWindow * w,
		   const WindowPaintAttrib * attrib,
		   Region region, unsigned int mask)
{
	Bool status;

	TD_SCREEN(w->screen);
	TD_WINDOW(w);
	if(tdw->currentZ > 0.01f)
	{
		glTranslatef(0.0f, 0.0f, tdw->currentZ);

		UNWRAP (tds, w->screen, paintWindow);
		status = (*w->screen->paintWindow) (w, attrib, region, mask);
		WRAP (tds, w->screen, paintWindow, tdPaintWindow);

		glTranslatef(0.0f, 0.0f, -tdw->currentZ);

	}
	
	else
	{
		UNWRAP (tds, w->screen, paintWindow);
		status = (*w->screen->paintWindow) (w, attrib, region, mask);
		WRAP (tds, w->screen, paintWindow, tdPaintWindow);
	}

	damageScreen (w->screen);

	return status;
}


static void
tdPaintTransformedScreen (CompScreen * s,
			  const ScreenPaintAttrib * sAttrib,
			  Region region,
			  int output,
			  unsigned int mask)
{
	TD_SCREEN(s);
	
	tds->transformed = TRUE;
	
	UNWRAP (tds, s, paintTransformedScreen);
	(*s->paintTransformedScreen) (s, sAttrib, region, output, mask);
	WRAP (tds, s, paintTransformedScreen, tdPaintTransformedScreen);
}

static Bool
tdPaintScreen (CompScreen * s,
 		const ScreenPaintAttrib * sAttrib,
		Region region, int output, unsigned int mask)
{
        Bool status;
	TD_SCREEN(s);
	
	tds->transformed = FALSE;
	
	UNWRAP (tds, s, paintScreen);
	status = (*s->paintScreen) (s, sAttrib, region, output, mask);
	WRAP (tds, s, paintScreen, tdPaintScreen);

        return status;
}

static void
tdDonePaintScreen (CompScreen * s)
{
	CompWindow *w;
	tdWindow *tdw;
	
	TD_SCREEN (s);
	
	if(tds->transformed)
	{
		for(w = s->windows; w; w = w->next)
		{
			tdw = GET_TD_WINDOW  (w, GET_TD_SCREEN  (w->screen, GET_TD_DISPLAY (w->screen->display)));
			
			if(tdw->currentZ - tdw->z < STEP && tdw->z - tdw->currentZ < STEP)
				tdw->currentZ = tdw->z;
			
			else if(tdw->currentZ < tdw->z)
				tdw->currentZ += STEP;
		
			else if(tdw->currentZ > tdw->z)
				tdw->currentZ -= STEP;
		}
	}
	
	else
	{
		for(w = s->windows; w; w = w->next)
		{
			tdw = GET_TD_WINDOW  (w, GET_TD_SCREEN  (w->screen, GET_TD_DISPLAY (w->screen->display)));
			
			if(tdw->currentZ < STEP && -tdw->currentZ < STEP)
				tdw->currentZ = 0;
			
			else if(tdw->currentZ < 0)
				tdw->currentZ += STEP;
		
			else if(tdw->currentZ > 0)
				tdw->currentZ -= STEP;
		}
	}
	
	UNWRAP (tds, s, donePaintScreen);
	(*s->donePaintScreen) (s);
	WRAP (tds, s, donePaintScreen, tdDonePaintScreen);
}

/*static void
tdHandleEvent (CompDisplay * d, XEvent * event)
{
	Window activeWindow = 0;
	CompWindow *w;
	tdWindow *tdw;
	
	CompWindow *tmpW;
	tdWindow *tdTmpW;
	
	float z = SPACE;

	TD_DISPLAY(d);
	
	switch(event->type)
	{
		case PropertyNotify:
			if (event->xproperty.atom == d->winActiveAtom)
				activeWindow = d->activeWindow;
				
			break;
			
		case UnmapNotify:
			w = findWindowAtDisplay (d, event->xunmap.window);
			tdw = GET_TD_WINDOW  (w, GET_TD_SCREEN  (w->screen, GET_TD_DISPLAY (w->screen->display)));
			
			//if(!windowIs3D(w))
			//	break;
			
			//Windows that weren't 3D, will have next=NULL.
				
			for(tdTmpW = tdw->next; tdTmpW; tdTmpW = tdTmpW->next)		
				tdTmpW->z -= SPACE;
			
			if(tdw->next)
				tdw->next->prev = tdw->prev;
			
			if(tdw->prev)
				tdw->prev->next = tdw->next;
			
			tdw->z = 0.0f;
			tdw->currentZ = 0.0f;
			
			tdw->next = NULL;
			tdw->prev = NULL;
			
			break;
		
		default:
			break;
	}
	
	
	UNWRAP (tdd, d, handleEvent);
	(*d->handleEvent) (d, event);
	WRAP (tdd, d, handleEvent, tdHandleEvent);
	
	switch(event->type)
	{
		case PropertyNotify:
			if (event->xproperty.atom == d->winActiveAtom)
			{
				if(d->activeWindow != activeWindow)
				{
					w = findWindowAtDisplay (d, d->activeWindow);
					tdw = GET_TD_WINDOW  (w, GET_TD_SCREEN  (w->screen, GET_TD_DISPLAY (w->screen->display)));
					
					if(!windowIs3D(w))
						break;
					
					if(tdw->next)
						tdw->next->prev = tdw->prev;
					
					if(tdw->prev)
						tdw->prev->next = tdw->next;
						
					for(tdTmpW = tdw->next; tdTmpW; tdTmpW = tdTmpW->next)
					{
						tdw->prev = tdTmpW;
						tdTmpW->z -= SPACE;
					}
					
					tdw->next = NULL;
					
					if(tdw->prev)
					{
						tdw->prev->next = tdw;
						tdw->z = tdw->prev->z + SPACE;
					}
					
					else
						tdw->z = SPACE;
				}
			}
			
			break;
	
		case MapNotify:
			w = findWindowAtDisplay (d, event->xmap.window);
			tdw = GET_TD_WINDOW  (w, GET_TD_SCREEN  (w->screen, GET_TD_DISPLAY (w->screen->display)));
			
			tdw->next = NULL;
			tdw->prev = NULL;
			
			if(!windowIs3D(w))
				break;
			
			for(tmpW = w->prev; tmpW; tmpW = tmpW->prev)
			{
				if(windowIs3D(tmpW) && isInSameViewport(w, tmpW))
				{
					tdTmpW = GET_TD_WINDOW  (tmpW, GET_TD_SCREEN  (tmpW->screen, GET_TD_DISPLAY (tmpW->screen->display)));		
					z = tdTmpW->z + SPACE;
					
					tdw->prev = tdTmpW;
					tdw->next = tdTmpW->next;
					
					tdTmpW->next = tdw;
					
					break;
				}
			}
			
			tdw->z = z;
			tdw->currentZ = 0.0f;
			
			for(tdTmpW = tdw->next; tdTmpW; tdTmpW = tdTmpW->next)
			{
				tdTmpW = GET_TD_WINDOW  (tmpW, GET_TD_SCREEN  (tmpW->screen, GET_TD_DISPLAY (tmpW->screen->display)));		
				tdTmpW->z += SPACE;
			}
			
			break;
		
		default:
			break;		
	}
}*/

static Bool
tdInitDisplay (CompPlugin  *p,
		 CompDisplay *d)
{
	tdDisplay *tdd;

	tdd = malloc (sizeof (tdDisplay));
	if (!tdd)
		return FALSE;

	tdd->screenPrivateIndex = allocateScreenPrivateIndex (d);
	if (tdd->screenPrivateIndex < 0)
	{
		free (tdd);
		return FALSE;
	}

	//WRAP (tdd, d, handleEvent, tdHandleEvent);

	d->privates[displayPrivateIndex].ptr = tdd;

	return TRUE;
}

static void
tdFiniDisplay (CompPlugin *p,
		 CompDisplay *d)
{
	TD_DISPLAY (d);

	freeScreenPrivateIndex (d, tdd->screenPrivateIndex);

	//UNWRAP (tdd, d, handleEvent);

	free (tdd);
}

static Bool
tdInitScreen (CompPlugin  *p,
		 CompScreen *s)
{
	TD_DISPLAY(s->display);

	tdScreen *tds;

	tds = malloc (sizeof (tdScreen));
	if (!tds)
		return FALSE;

	tds->windowPrivateIndex = allocateWindowPrivateIndex (s);
	if (tds->windowPrivateIndex < 0)
	{
		free (tdd);
		return FALSE;
	}
	
	tds->transformed = FALSE;
	
	WRAP(tds, s, paintTransformedScreen, tdPaintTransformedScreen);
	WRAP(tds, s, paintWindow, tdPaintWindow);
	WRAP(tds, s, paintScreen, tdPaintScreen);
	WRAP(tds, s, donePaintScreen, tdDonePaintScreen);
	WRAP(tds, s, preparePaintScreen, tdPreparePaintScreen);
	
	s->privates[tdd->screenPrivateIndex].ptr = tds;

	return TRUE;
}

static void
tdFiniScreen (CompPlugin *p,
		 CompScreen *s)
{
	TD_SCREEN (s);

	freeWindowPrivateIndex (s, tds->windowPrivateIndex);
	
	UNWRAP(tds, s, paintTransformedScreen);
	UNWRAP(tds, s, paintWindow);
	UNWRAP(tds, s, paintScreen);
	UNWRAP(tds, s, donePaintScreen);
	UNWRAP(tds, s, preparePaintScreen);
	
	free (tds);
}

static Bool
tdInitWindow (CompPlugin * p, CompWindow * w)
{
	tdWindow *tdw;
	/*tdWindow *tdTmpW;
	CompWindow *tmpW;

	float z=SPACE;
	int i;*/

	TD_SCREEN (w->screen);

	tdw = malloc (sizeof (tdWindow));
	if (!tdw)
		return FALSE;
	
	/*tdw->next = (tdWindow**) malloc (sizeof(tdWindow*) * (w->screen->hsize));
	
	for(i = 0; i < w->screen->hsize; i++)
		w->next[i] = NULL;
	tdw->i = 0;
	
	tdw->prev = NULL;
	
	if(windowIs3D(w))
	{
		printf(w->startupId);
		printf(" ");
		printf(w->resName);
		printf(" ");
		printf(w->resClass);
		printf(" ");
		printf("%d %d\n", w->attrib.x, w->attrib.width);
		
		//for(tmpW = w->next; tmpW; tmpW = tmpW->next)
		//{
		//	if(getWindowType(tmpW->screen->display, tmpW->id) == CompWindowTypeNormalMask)
		//	{
		//		printf("!\n");
		//		tdTmpW = GET_TD_WINDOW  (tmpW, GET_TD_SCREEN  (tmpW->screen, GET_TD_DISPLAY (tmpW->screen->display)));		
		//		printf("!!\n");
		//		if(tdTmpW)
		//		{
		//			printf("!!!\n");
		//			tdTmpW->z += SPACE;
		//		}
		//		printf("!!!!\n");
		//	}
		//}
		
		for(tmpW = w->prev; tmpW; tmpW = tmpW->prev)
		{
			if(windowIs3D(tmpW) && isInSameViewport(w, tmpW))
			{
				printf("After: ");
				printf(tmpW->resName);
				printf("\n");
				tdTmpW = GET_TD_WINDOW  (tmpW, GET_TD_SCREEN  (tmpW->screen, GET_TD_DISPLAY (tmpW->screen->display)));		
				z=tdTmpW->z+SPACE;
				
				tdw->prev = tdTmpW;
				tdTmpW->next = tdw;
				break;
			}
		}
		
		printf("%f\n\n", z);
	}
	
	else
		z=0.0f;*/
	
	tdw->z=/*z*/0.0f;
	tdw->currentZ=0.0f;
	
	w->privates[tds->windowPrivateIndex].ptr = tdw;

	return TRUE;
}

static void
tdFiniWindow (CompPlugin * p, CompWindow * w)
{
	/*tdWindow *tdTmpW;*/

	TD_WINDOW (w);
	
	/*if(windowIs3D(w))
	{	
		for(tdTmpW = tdw->next; tdTmpW; tdTmpW = tdTmpW->next)	
			tdTmpW->z -= SPACE;
	}
	
	if(tdw->prev)
		tdw->prev->next = tdw->next;
	
	if(tdw->next)
		tdw->next->prev = tdw->prev;*/
	
	free (tdw);
}

static Bool
tdInit (CompPlugin *p)
{
	displayPrivateIndex = allocateDisplayPrivateIndex ();
	if (displayPrivateIndex < 0)
		return FALSE;

	return TRUE;
}

static void
tdFini (CompPlugin *p)
{
	if (displayPrivateIndex >= 0)
		freeDisplayPrivateIndex (displayPrivateIndex);
}

static int
tdGetVersion (CompPlugin *plugin,
		int	   version)
{
    return ABIVERSION;
}


static CompPluginVTable opacityVTable = {
	"3d",
	"A 3D world",
	"Windows live in a 3D world.",
	tdGetVersion,
	tdInit,
	tdFini,
	tdInitDisplay,
	tdFiniDisplay,
	tdInitScreen,
	tdFiniScreen,
	tdInitWindow,
	tdFiniWindow,
	/*tdGetDisplayOptions*/ 0,
	/*tdSetDisplayOption*/ 0,
	/*tdGetScreenOptions*/ 0,
	/*tdSetScreenOption*/ 0,
	NULL,
	0,
	0,
	0
};

CompPluginVTable *
getCompPluginInfo (void)
{
	return &opacityVTable;
}
