/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/

// qt specific
#include <qpopupmenu.h>
// kde specific
#include <kiconloader.h>
// menu specific
#include "lazyfillmenu.h"
#include "contactmenufiller.h"
#include "contactlistmenufiller.h"


ContactListMenuFiller::ContactListMenuFiller( AddresseeListSpan Span, const QString &FirstToken, const QString &LastToken )
 : ContactsSpan( Span ), UpperFirstEntryToken( FirstToken ), UpperLastEntryToken( LastToken )

{
}


// TODO: calculate limit by screen size
static const int Limit = 30;

static const int MinChars = 3;
static const int MaxChars = 6;

void ContactListMenuFiller::createTokens( QString &PreviousToken, QString &NextToken, 
                                      const QString &Previous, const QString &Next )
{
    // finde gemeinsame Länge
    unsigned int Length = MaxChars;
    if( Previous.length() < Length )
        Length = Previous.length();
    if( Next.length() < Length )
        Length = Next.length();

    // suche Position des Unterschiedes
    unsigned int i = MinChars-1;
    for( ; i<Length; ++i )
        if( Previous[i] != Next[i] )
            break;

    // 
    ++i;
    PreviousToken = Previous.left( i ).stripWhiteSpace();
    NextToken =     Next.left( i ).stripWhiteSpace();
}

void ContactListMenuFiller::fill( QPopupMenu *Menu )
{
    if( ContactsSpan.number() > Limit )
    {
        int SizeSubMenus = ContactsSpan.number() / Limit + 1;

        KABC::Addressee::List::ConstIterator it = ContactsSpan.begin();
        QString NextFirstEntryToken = UpperFirstEntryToken;
        QString LastEntryToken;

        do
        {
            AddresseeListSpan SubSpan( it, SizeSubMenus, ContactsSpan.end() );

            // create shorts
            QString FirstEntryToken = NextFirstEntryToken;
            if( it != ContactsSpan.end() )
                createTokens( LastEntryToken, NextFirstEntryToken, SubSpan.last().realName(), (*it).realName() );
            else
                LastEntryToken = UpperLastEntryToken;

            LazyFillMenu *SubMenu = createSubMenu(
               new ContactListMenuFiller(SubSpan,FirstEntryToken,LastEntryToken), Menu );

            Menu->insertItem( SmallIconSet("contents"), protectAmpersand(FirstEntryToken+QString("...")+LastEntryToken), SubMenu );
        }
        while( it != ContactsSpan.end() );
    }
    else
    {
        KABC::Addressee::List::ConstIterator it = ContactsSpan.begin();

        while( it != ContactsSpan.end() )
            ContactMenuFiller::createEntry( *it++, Menu );
    }
}


LazyFillMenu *ContactListMenuFiller::createSubMenu( MenuFiller *Filler, QPopupMenu *Menu )
{
      return new LazyFillMenu( Filler, false, Menu );
}
