/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef CONTACTMENUFILLER_H
#define CONTACTMENUFILLER_H


// kde specific
#include <kabc/addressee.h>
// menu specific
#include "menufiller.h"


class ContactMenuFiller : public QObject, public MenuFiller
{
  Q_OBJECT
public:
    static void createEntry( const KABC::Addressee Contact, QPopupMenu *Menu );

public:
    ContactMenuFiller( const KABC::Addressee C );

public: // MenuFiller API
    virtual void fill( QPopupMenu *Menu );

public slots:
    void launchAddressEditor() const;

protected:
    /** sublist of contacts to care of */
    const KABC::Addressee Contact;
};

#endif
