/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef MENUFILLER_H
#define MENUFILLER_H


// qt specific
#include <qstring.h>


class QPopupMenu;

class MenuFiller
{
public:
    MenuFiller();
    virtual ~MenuFiller();
public:
    virtual void fill( QPopupMenu *Menu ) = 0;
public:
   // converts all ampersands to double ampersands
    static QString protectAmpersand( const QString &String );
};


inline QString MenuFiller::protectAmpersand( const QString &String )
{
    return QString(String).replace( '&', "&&" );
}

#endif
