/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/



// menu specific
#include "contactsmenu.h"
#include "lazyfillmenu.h"
#include "menufiller.h"


TopContactListMenuFiller::TopContactListMenuFiller()
: ContactListMenuFiller( KABC::AddresseeList(), QString::null, QString::null )
{
    SubMenuStore.setAutoDelete( true );
}



void TopContactListMenuFiller::fill( QPopupMenu *Menu, const AddresseeListSpan Span )
{
    ContactsSpan = Span;
    QString Dummy;
    // we only need and can cre
    if( Span.number() > 1 )
    {
        Addressee::List::ConstIterator it = ContactsSpan.begin();
        const QString &FirstName = (*it).realName();
        const QString &SecondName = (*++it).realName();
        createTokens( UpperFirstEntryToken, Dummy, FirstName, SecondName );

        it = ContactsSpan.end();
        const QString &LastName = (*--it).realName();
        const QString &PreLastName = (*--it).realName();
        createTokens( Dummy, UpperLastEntryToken, PreLastName, LastName );
    }

    ContactListMenuFiller::fill( Menu );
}


LazyFillMenu *TopContactListMenuFiller::createSubMenu( MenuFiller *Filler, QPopupMenu */*Menu*/ )
{
  LazyFillMenu *SubMenu = new LazyFillMenu( Filler, false, 0 );
  SubMenuStore.append( SubMenu );

  return SubMenu;
}
