/*
** Copyright 2000-2002 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"

#include	"afx/afx.h"
#include	"afx/afxtempl.h"
#include	"rfc822/rfc822.h"
#include	"random128/random128.h"
#include	"numlib/numlib.h"
#include	"dbobj.h"

#if	HAVE_LOCALE_H
#include	<locale.h>
#endif

#include	<iostream>
#include	<iomanip>
#include	<fstream>
#include	<signal.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/wait.h>
#include	<fcntl.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<errno.h>
#include	<ctype.h>
#include	<time.h>
#include	"mydirent.h"
#include	<sysexits.h>

#include "cmlm.h"
#include "cmlmsublist.h"
#include "cmlmsubunsub.h"
#include "cmlmsubunsubmsg.h"
#include "cmlmcmdmisc.h"
#include "cmlmstartmail.h"
#include "cmlmarchive.h"
#include "cmlmmoderate.h"
#include "cmlmbounce.h"
#include "cmlmcleanup.h"
#include "cmlmfetch.h"

static const char rcsid[]="$Id: cmlm.C,v 1.23 2005/04/05 15:42:18 mrsam Exp $";

//	Keywords we try to trap for messages sent to the list address.


static const char *admin_keywords[]={
	"subscribe",
	"unsubscribe",
	"help",
	0
	};

static void usage()
{
	cerr << "Usage: cmlm [command] [directory] [options]..." << endl;
	exit(1);
}


static int cmdctlmsg(int, char **);
static int cmdmsg(int, char **);

static struct cmdtab {
	const char *cmdname;
	int (*cmdfunc)(int, char **);
	} commands[]={

	{"create", cmdcreate},
	{"set", cmdset},
	{"sub", cmdsub},
	{"unsub", cmdunsub},
	{"lsub", cmdlsub},
	{"export", cmdexport},
	{"import", cmdimport},
	{"laliases", cmdlaliases},
	{"info", cmdinfo},
	{"ctlmsg", cmdctlmsg},
	{"msg", cmdmsg},
	{"hourly", cmdhourly},
	{"daily", cmddaily},
	{"digest", cmddigest},
	} ;

int main(int argc, char **argv)
{
	if (argc < 3)	usage();

#if HAVE_SETLOCALE
	setlocale(LC_ALL, "C");
#endif

	signal(SIGPIPE, SIG_IGN);
	signal(SIGCHLD, SIG_DFL);

const char *cmd=argv[1];
const char *dir=argv[2];

	if (strcmp(cmd, "create") == 0)
	{
	int	i;

		for (i=3; i<argc; i++)
			if (strncmp(argv[i], "ADDRESS=", 8) == 0)
				break;

		if (i >= argc)
		{
			cerr << "Missing ADDRESS." << endl;
			return (EX_SOFTWARE);
		}

		if (mkdir(dir, 0700))
		{
			perror(dir);
			exit(1);
		}
	}

	if (chdir(dir))
	{
		perror(dir);
		exit(1);
	}

unsigned	i;

	for (i=0; i<sizeof(commands)/sizeof(commands[0]); i++)
		if (strcmp(commands[i].cmdname, cmd) == 0)
			exit ( (*commands[i].cmdfunc)(argc-3, argv+3));
	usage();
	return (0);
}

////////////////////////////////////////////////////////////////////////////
//
// Control message
//

static int help();

static int cmdctlmsg(int argc, char **argv)
{
const char *cmd=getenv("DEFAULT");

	if (!cmd)	cmd="";

	if (strcasecmp(cmd, "help") == 0)
		return (help());

	if (strncasecmp(cmd, "subscribe", 9) == 0)
	{
		cmd += 9;
		if (*cmd == 0 || (*cmd == '-' && *++cmd != 0))
			return (dosub(cmd));
	}
	else if (strncasecmp(cmd, "alias-subscribe", 15) == 0)
	{
		cmd += 15;
		if (*cmd == 0 || (*cmd == '-' && *++cmd != 0))
			return (doalias(cmd));
	}
	else if (strncasecmp(cmd, "modsubconfirm-", 14) == 0)
	{
		cmd += 14;
		if (*cmd)
			return (domodsub(cmd));
	}
	else if (strncasecmp(cmd, "unsubscribe", 11) == 0)
	{
		cmd += 11;
		if (*cmd == 0 || (*cmd == '-' && *++cmd != 0))
			return (dounsub(cmd));
	}
	else if (strncasecmp(cmd, "subconfirm-", 11) == 0)
	{
		cmd += 11;
		if (*cmd)
			return (dosubunsubconfirm(cmd, "sub",
					docmdsub,
					"sub2.tmpl",
					"sub3.tmpl", 0));
	}
	else if (strncasecmp(cmd, "aliasconfirm-", 13) == 0)
	{
		cmd += 13;
		if (*cmd)
		{
		int rc=dosubunsubconfirm(cmd, "alias",
					docmdalias,
					"sub2.tmpl",
					"sub3.tmpl", 1);
			if (rc == 9)
				rc=EX_SOFTWARE;
			return (rc);
		}
	}
	else if (strncasecmp(cmd, "bounce-", 7) == 0)
	{
		cmd += 7;
		if (*cmd)
			return (dobounce(cmd));
	}
	else if (strncasecmp(cmd, "bounce1-", 8) == 0)
	{
		if (*cmd)
			return (dobounce1(cmd));
	}
	else if (strncasecmp(cmd, "bounce2-", 8) == 0)
	{
		if (*cmd)
			return (dobounce2(cmd));
	}
	else if (strncasecmp(cmd, "unsubconfirm-", 13) == 0)
	{
		cmd += 13;
		if (*cmd)
			return (dosubunsubconfirm(cmd, "unsub",
					docmdunsub,
					"unsub2.tmpl",
					"unsub3.tmpl", 0));
	}
	else if (strcasecmp(cmd, "moderate") == 0)
	{
		return (cmdmoderate());
	}
	else if (strncasecmp(cmd, "index", 5) == 0)
	{
		cmd += 5;
		if (*cmd == 0 || *cmd++ == '-')
			return (doindex(cmd));
	}
	else if (strncasecmp(cmd, "fetch-", 6) == 0)
	{
		cmd += 6;
		if (*cmd)
			return (dofetch(cmd));
	}
	cerr << "Invalid address.\n";
	return (1);
}

//////////////////////////////////////////////////////////////////////////
//
// Send back a template, followed by copy of the original headers
//
//////////////////////////////////////////////////////////////////////////

void ack_template(ostream &fs, const char *filename, CString msg)
{
ifstream	ifs(filename);
CString	buf;
size_t	i=(size_t)msg.GetLength();
size_t	j;

	while ((buf << ifs) == 0)
		fs << buf << endl;

	fs << MSGSEPARATOR << endl << endl;
	for (j=1; j<i; j++)
		if (msg[j-1] == '\n' && msg[j] == '\n')
		{
			msg=msg.Left(j);
			break;
		}
	fs << msg;
}

//
//  Determine if this is a good confirm.
//
int goodconfirm(CString msg)
{
CString	subject=header(msg, "subject");
int	i;

	if (cmdget("SIMPLECONFIRM") == "1")
		return (0);

	// Search for 'yes' in the subject.

	if (subject == "")	return (-1);
	for (i=0; i<subject.GetLength(); i++)
		if (strncasecmp((const char *)subject+i, "yes", 3) == 0)
			break;
	if (i >= subject.GetLength())	return (-1);
	return (0);
}

/////////////////////////////////////////////////////////////////////////////
//
// Distribute a message.
//
/////////////////////////////////////////////////////////////////////////////

static const char *fn;
static const char *fn2;

static RETSIGTYPE sighandler(int n)
{
	unlink(fn);
	if (fn2)	unlink(fn2);
	_exit(1);
#if	RETSIGTYPE != void
	return (0);
#endif
}

void trapsigs(const char *p)
{
	fn=p;
	fn2=0;
	signal(SIGINT, sighandler);
	signal(SIGHUP, sighandler);
	signal(SIGTERM, sighandler);
	signal(SIGPIPE, SIG_IGN);
}

static void trapsig2(const char *p)
{
	fn2=p;
}

void clearsigs(int rc)
{
	if (rc)
	{
		unlink(fn);
		if (fn2)	unlink(fn2);
	}

	signal(SIGINT, SIG_DFL);
	signal(SIGHUP, SIG_DFL);
	signal(SIGTERM, SIG_DFL);
}

static int savemsg(istream &, ostream &);

static int cmdmsg(int argc, char **argv)
{
CString	postoptions= cmdget("POST");

	if (postoptions.GetLength() > 0 &&
		postoptions == "mod")
	{
	int	rc=0;

	//
	//	Insert into the moderators queue
	//

	CString	modfilename=mktmpfilename();
	CString	tmodname=TMP "/" + modfilename;
	CString	mmodname=MODQUEUE "/" + modfilename;

		trapsigs(tmodname);

	fstream	modfs(tmodname, ios::in | ios::out | ios::trunc);

		if (!modfs.is_open())
		{
			perror(tmodname);
			rc=EX_TEMPFAIL;
		}

	const char *token=random128_alpha();

		if (rc == 0)
		{
			modfs << "X-Magic-Token: " << token << endl;
			rc=savemsg(cin, modfs);
		}

	ExclusiveLock modqueue_lock(MODQUEUELOCKFILE);

		if (rc || rename (tmodname, mmodname))
		{
			modfs.close();
			clearsigs(rc);
			return (rc);
		}

		clearsigs(0);
		modfs.close();

		int fd_msg=open(mmodname, O_RDONLY);
		if (fd_msg < 0)
		{
			perror(mmodname);
			exit(EX_OSERR);
		}

		afxipipestream ifs(fd_msg);

		rc=sendinitmod(ifs, modfilename, "modtext.tmpl");
		return (rc);
	}
	return (postmsg(cin, savemsg));
}

//----------------------------------------------------------------------------
//
// The postmsg() function posts a message to the mailing list.  postmsg()
// is used to post messages to both unmoderated and moderated mailing lists.
// For a moderated mailing list, postmsg() is called to post a moderator
// approved message.  postmsg()'s behavior is controlled by passing it two
// arguments:
//
// msgsource - the source of the message.  For unmoderated mailing lists,
// this is cin/stdin, the message as its being delivered directly to
// couriermlm. For moderated mailing list, this is an opened file in
// modqueue, that the moderator just approved.
//
// savefunc - a function that copies a message from an input source (the
// msgsource argument), to an output stream, transforming the message for
// mailing list posting.  For unmoderated mailing lists, this is savemsg(),
// which removed and adds headers based upon the headerdel/headeradd control
// files.  For a moderated list this is a stub function that simply copies
// an input stream to an output stream (that's because savemsg() was already
// called previously when the message was inserted into the moderator queue.
//
// In both cases, savefunc *must* call flush on the output stream!
//
// postmsg() allocates a message sequence number in the archive directory,
// calls savefunc() to save the message in the archive directory, then
// repeatedly mails the message to everyone on the mailing list.
//
//----------------------------------------------------------------------------

int postmsg(istream &msgsource, int (*savefunc)(istream &, ostream &))
{
char	buf[NUMBUFSIZE+100], buf2[NUMBUFSIZE+100];
unsigned long nextseqno;
int	rc;
fstream fs;

{
Archive archive;

	if ( (rc=archive.get_seq_no(nextseqno)) != 0)
		return (rc);

	libmail_str_off_t(nextseqno, buf);

	if ( (rc=archive.save_seq_no()) != 0)
		return (rc);

CString	filename_str(archive.filename(nextseqno));

	trapsigs(filename_str);

	fs.open(filename_str, ios::in | ios::out | ios::trunc);
	if (!fs.is_open())
	{
		perror(filename_str);
		rc=EX_TEMPFAIL;
	}
	else	rc=(*savefunc)(msgsource, fs);

	if (rc == 0)
	{
		if (rename(NEXTSEQNO, SEQNO))
		{
			perror(SEQNO);
			rc=EX_TEMPFAIL;
		}
	}

CString	digestdir;

	if (rc == 0)
	{
		digestdir=cmdget("DIGEST");
		if (digestdir.GetLength() > 0)
		{
			digestdir += "/" MODQUEUE "/";
			digestdir += buf;
			trapsig2(digestdir);
			if ((rc=link(filename_str, digestdir)) != 0)
				perror(digestdir);
		}
	}

	clearsigs(rc);
}
	if (rc == 0)
	{
		strcpy(buf2, "bounce-");
		strcat(buf2, buf);
		post(fs, buf2);
	}

	fs.close();
	return (rc);
}

static void get_post_address(const char *p, CString &addr)
{
	if (strncmp(p, "x-couriermlm-date:", 18) == 0)
	{
		p += 18;
		while (*p && *p != '\n' && isspace((int)(unsigned char)*p))
			++p;
		while (isdigit((int)(unsigned char)*p))
		{
			++p;
		}
		while (*p && *p != '\n' && isspace((int)(unsigned char)*p))
			++p;

		size_t i;
		bool atfound=false;

		for (i=0; p[i] && p[i] != '\n'; i++)
			if (p[i] == '@')
				atfound=true;

		if (atfound)
			addr=CString(p, i);
	}
}

void post(istream &fs, const char *verp_ret)
{
SubscriberList	sublist;
StartMail	mail(fs, verp_ret);
CString	addr, lastaddr;

	if ( sublist.Next(addr) == 0)
	{
		get_post_address(sublist.sub_info, addr);
		mail.To(addr);
		lastaddr=addr;

		// Call Send() when we change domains, VERP works better
		// that way.

		while (sublist.Next(addr) == 0)
		{
		const char *a=strrchr(addr, '@');
		const char *b=strrchr(lastaddr, '@');

			if (!a || !b || strcmp(a, b))
				mail.Send();

			get_post_address(sublist.sub_info, addr);
			mail.To(addr);
			lastaddr=addr;
		}
	}
	mail.Send();
}

static int savemsg(istream &msgs, ostream &fs)
{
const char *dt=getenv("DTLINE");
char	buf[BUFSIZ];
int	n;
CString keyword= cmdget("KEYWORD"), keywords;
int	adminrequest=0;

	if (keyword.GetLength() > 0)
		keywords="["+keyword+"]";

	if (dt && *dt)
		fs << dt << endl;

	{
	ifstream ifs(HEADERADD);

		if (ifs.is_open())
			while (!ifs.eof() && !ifs.bad())
			{
				while ((n=ifs.get()) != EOF)
				{
					fs.put(n);
					if (n == '\n')
						break;
				}
			}
	}

CMap<CString, CString, int, int>	delete_headers;

	{
	ifstream ifs(HEADERDEL);

		if (ifs.is_open())
			while (!ifs.eof() && !ifs.bad())
			{
				int	i;
				int	n;

				i=0;

				while ((n=ifs.get()) != EOF && n != '\n')
				{
					if (i < (int)(sizeof(buf)-1))
						buf[i++]=n;
				}
				buf[i]=0;
				for (i=0; buf[i]; i++)
					buf[i]=tolower((int)(unsigned char)
							buf[i]);
				delete_headers[buf]=1;
			}
	}

CString	h;
int	dummy;

CString	from;

	while (!msgs.eof() && !msgs.bad())
	{
		int i, n;

		i=0;
		while ((n=msgs.get()) != EOF && n != '\n')
		{
			if (i >= (int)(sizeof(buf)-1))
				break;

			buf[i++]=n;
		}

		buf[i]=0;

		if (i == 0)
		{
			fs.put('\n');
			break;
		}

		if (n != EOF)
			msgs.putback(n);

	char	*p=strchr(buf, ':');

		if (isspace((int)(unsigned char)buf[0]))
			p=0;

		if (p)
		{
			++p;

		char	*hh=h.GetBuffer(p-buf);

			memcpy(hh, buf, p-buf);
			hh[p-buf]=0;
			while (*hh)
			{
				*hh=tolower((int)(unsigned char)*hh);
				++hh;
			}

			h.ReleaseBuffer(p-buf);

			if (h == "subject:")
			{
			char *q=strchr(buf, ':')+1;
			unsigned i;

				while (q && *q && isspace((int)(unsigned char)
					*q))
					++q;

				for (i=0; admin_keywords[i]; i++)
				{
				int l=strlen(admin_keywords[i]);

					if (strncasecmp(q, admin_keywords[i], l)
						== 0 && (q[l] == 0 ||
							!isalpha((int)
								(unsigned char)
								q[l])))
					{
						adminrequest=1;
						break;
					}
				}
			}

			if (h == "subject:" && keyword.GetLength() > 0)
			{
			char *q=p;

				for ( ; *q; q++)
				{
					if (*q != '[')
						continue;
					if (strncasecmp(q, keywords,
						keywords.GetLength()) == 0)
						break;
				}

				if (*q == 0)
				{
				CString newline= "Subject: " + keywords + p;

					buf[0]=0;
					strncat(buf, newline, sizeof(buf)-1);
				}
			}

			if (h == "from:")
			{
			int	dodelete=delete_headers.Lookup(h, dummy);

				if (!dodelete)
					fs.write(buf, strlen(buf));

				from=p;
				while ((n=msgs.get()) != EOF)
				{
					if (!dodelete)	fs << (char)n;

					if (n == '\n')
					{
						n=msgs.peek();
						if ( n == EOF ||
							!isspace((int)
							   (unsigned char)n)
							|| n == '\r'
							|| n == '\n')
							break;
					}
					from += (char)n;
				}

			struct rfc822t *t=rfc822t_alloc(from, 0);

				if (!t)
				{
					perror("malloc");
					return (EX_TEMPFAIL);
				}

			struct rfc822a *a=rfc822a_alloc(t);

				if (!a)
				{
					rfc822t_free(t);
					perror("malloc");
					return (EX_TEMPFAIL);
				}

			char *nn=0;

				if (a->naddrs > 0)
				{
					nn=rfc822_getaddr(a, 0);
					if (!nn)
					{
						rfc822a_free(a);
						rfc822t_free(t);
						perror("malloc");
						return (EX_TEMPFAIL);
					}
				}
				rfc822a_free(a);
				rfc822t_free(t);
				if (nn)
				{
					from=nn;
					free(nn);
				}
				else	from="";
				continue;
			}

		}

		if (p && delete_headers.Lookup(h, dummy))
		{
			// Drop this header

			while ((n=msgs.get()) != EOF)
				if (n == '\n')
				{
					n=msgs.peek();
					if ( n == EOF ||
						!isspace((int)(unsigned char)n)
						|| n == '\r' || n == '\n')
						break;
				}
			continue;
		}

		fs.write(buf, strlen(buf));

		while ((n=msgs.get()) != EOF)
		{
			fs.put(n);
			if (n == '\n')
				break;
		}
	}

int	first_line=1;

	while (!msgs.eof() && !msgs.bad())
	{
	int	n;
	const char *p;


	int	i=0;

		while ((n=msgs.get()) != EOF && n != '\n')
		{
			if (i >= (int)(sizeof(buf)-1))
				break;

			buf[i++]=n;
		}

		buf[i]=0;

		if (n != EOF)
			msgs.putback(n);

		fs.write(buf, strlen(buf));
		while ((n=msgs.get()) != EOF)
		{
			fs.put(n);
			if (n == '\n')	break;
		}

		// Check for "subscribe/unsubscribe on the first line" wankers.

		if (!first_line)	continue;

		for (p=buf; *p; p++)
			if (!isspace((int)(unsigned char)*p))
				break;

		if (!*p)	continue;
		first_line=0;

		for (n=0; admin_keywords[n]; n++)
		{
		int l=strlen(admin_keywords[n]);

			if (strncasecmp(p, admin_keywords[n], l) == 0 &&
				(p[l] == 0 || !isalpha((int) (unsigned char)
							p[l])))
			{
				adminrequest=1;
				break;
			}
		}
	}

	fs.flush();
	fs.seekp(0);
	if (fs.bad() || fs.fail())
	{
		perror(	"write" );
		return (EX_TEMPFAIL);
	}

	if ( cmdget("NOBOZOS") == "0")
		adminrequest=0;

	if (adminrequest)
	{
	ifstream ifs("adminrequest.tmpl");
	CString	buf;
	int	flag=0;

		while ((buf << ifs) == 0)
		{
			cout << buf << endl;
			flag=1;
		}
		if (!flag)	cout << "Administractive request blocked."
						<< endl;
		cout << flush;
		return (EX_NOUSER);
	}


int	rc=is_subscriber(from);

	if (rc == EX_NOUSER)
	{
	CString	postoptions= cmdget("POST");

		if (postoptions.GetLength() > 0 &&
			postoptions == "all")
			rc=0;
	}

	if (rc)
	{
		if (rc == EX_NOUSER)
		{
			cout << "You are not subscribed to this mailing list."
				<< endl;
		}
		rc=EX_NOPERM;
		return (rc);
	}

	return (0);
}

void copy_report(const char *s, afxopipestream &o)
{
	int i_fd=open(s, O_RDONLY);

	if (i_fd < 0)
	{
		perror(s);
		exit(1);
	}

	afxipipestream i(i_fd);

	if (copyio_noseek(i, o) < 0)
	{
		perror(s);
		exit(1);
	}
}

int copyio(afxipipestream &i, afxopipestream &o)
{
	i.seekg(0);
	if (i.bad())
	{
		perror("seek");
		return (EX_OSERR);
	}

	return (copyio_noseek(i, o));
}

int copyio_noseek(afxipipestream &i, afxopipestream &o)
{
	return (copyio_noseek_cnt(i, o, 0));
}

int copyio_noseek_cnt(afxipipestream &i, afxopipestream &o,
		      unsigned long *maxbytes)
{
char	buf[BUFSIZ];

	i.read(buf, sizeof(buf));

int	x;

	while ((x=i.gcount()) > 0)
	{
		if (maxbytes)
		{
			if ((unsigned long)x > *maxbytes)
			{
				cerr << "Message too large." << endl;
				return (EX_SOFTWARE);
			}
			*maxbytes -= x;
		}

		o.write(buf, x);
		i.read(buf, sizeof(buf));
	}
	if (o.bad() || i.bad())
		return (EX_OSERR);
	return (0);
}

static int tryboundary(afxipipestream &io, const char *boundary)
{
int	boundary_l=strlen(boundary);
CString	line;

	io.clear();
	io.seekg(0);
	if (io.fail())	return (-1);

	while ((line << io) == 0)
	{
		if (strncmp(line, boundary, boundary_l) == 0)
			return (1);
	}
	io.clear();
	return (0);
}

// Create MIME multipart boundary delimiter.

CString mkboundary_msg(afxipipestream &io)
{
CString	base=mkfilename();
unsigned i=0;
CString	boundary;
int	rc;

	do
	{
		// ostringstream

		boundary=base;
		boundary += ".";

		char buf[NUMBUFSIZE];

		libmail_str_size_t(i, buf);

		size_t l=strlen(buf);

		while (l < 3)
		{
			boundary += '0';
			++l;
		}
		boundary += buf;

	} while ((rc=tryboundary(io, boundary)) > 0);
	if (rc)	return ("");
	return (boundary);
}

static int help()
{
CString	msg(readmsg());
CString addr=returnaddr(msg, "");
pid_t	p;

	if (addr.Find('@') < 0)	return (0);

time_t	curtime;

	time(&curtime);

	addrlower(addr.GetBuffer(-1));

CString	vaddr= TMP "/help." + toverp(addr);
struct	stat	sb;

	if (stat(vaddr, &sb) == 0 && sb.st_mtime + 30 * 60 > curtime)
		return (0);

	close(open(vaddr, O_RDWR|O_CREAT, 0755));

CString owner=get_verp_return("owner", 0);
afxopipestream ack(sendmail_bcc(p, owner));

	ack << "From: " << myname() << " <" << owner << ">" << endl
			<< "To: " << addr << endl
			<< "Bcc: " << addr << endl;

	ack_template(ack, "help.tmpl", msg);
	ack.close();
	return (wait4sendmail(p));
}
