/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"cmlm.h"
#include	"cmlmcmdmisc.h"
#include	"cmlmsubunsub.h"
#include	"dbobj.h"
#include	"cmlmsublist.h"
#include	<iostream>
#include	<fstream>
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<ctype.h>
#include	<time.h>
#include	"mydirent.h"
#include	<fcntl.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sysexits.h>

static const char rcsid[]="$Id: cmlmcmdmisc.C,v 1.6 2005/04/05 20:49:01 mrsam Exp $";

// Create a mailing list

int cmdcreate(int argc, char **argv)
{
ofstream ofs(OPTIONS);
DIR	*dirp;
struct	dirent *de;

	if (!ofs.is_open())
	{
		perror(OPTIONS);
		return (1);
	}
	while (argc)
	{
		ofs << *argv << endl;
		++argv;
		--argc;
	}
	ofs << flush;
	if (ofs.bad())
	{
		perror(OPTIONS);
		return (1);
	}

	if (mkdir(TMP, 0755))
	{
		perror(TMP);
		return (1);
	}

	if (mkdir(DOMAINS, 0755))
	{
		perror(DOMAINS);
		return (1);
	}

	if (mkdir(COMMANDS, 0755))
	{
		perror(COMMANDS);
		return (1);
	}
	if (mkdir(ARCHIVE, 0755))
	{
		perror(ARCHIVE);
		return (1);
	}
	if (mkdir(UNSUBLIST, 0755))
	{
		perror(UNSUBLIST);
		return (1);
	}
	if (mkdir(MODQUEUE, 0755))
	{
		perror(MODQUEUE);
		return (1);
	}
	if (mkdir(BOUNCES, 0755))
	{
		perror(BOUNCES);
		return (1);
	}

CString	addr=cmdget("ADDRESS");

	// Copy all the template files

	dirp=opendir(TEMPLATEDIR);
	while (dirp && (de=readdir(dirp)) != 0)
	{
	const char *p=strrchr(de->d_name, '.');
	CString	n;
	CString	line;
	CString	s;

		if (!p || strcmp(p, ".tmpl"))	continue;
		n= TEMPLATEDIR "/";
		n += de->d_name;

	ifstream	ifs(n);

		if (ifs.bad())
		{
			perror(n);
			return (1);
		}

	ofstream	ofs(de->d_name);

		if (ofs.bad())
		{
			perror(de->d_name);
			return (1);
		}

		// Copy line at a time, expanding the address macro

		while ((line << ifs) == 0)
		{
		int	i;

			for (i=0; i<line.GetLength(); i++)
			{
				if (line[i] != '#' || line[i+1] != '#')
					continue;

				s=line.Mid(i+2);

			int	j=s.Find('#');

				if (j < 0 || ((const char *)s)[j+1] != '#')
					continue;

				s=s.Left(j);
				if (s.GetLength() > 0)	s= "-" + s;

			int	k=addr.ReverseFind('@');

				if (k < 0)	k=0;

				s= "mailto:" + addr.Left(k)
					+ s + addr.Mid(k);
			
				line= line.Left(i) + s + line.Mid(i+j+4);
				i += j+3;	
			}
			ofs << line << endl;
		}
		ofs.flush();
		if (ofs.fail())
		{
			perror(de->d_name);
			return (1);
		}
		ofs.close();
		if (ofs.fail())
		{
			perror(de->d_name);
			return (1);
		}
	}
	if (dirp)	closedir(dirp);

	if (addr.GetLength() > 0)
	{
	ofstream ofs(HEADERADD);

		ofs << "List-Subscribe: <mailto:" <<
			get_verp_return("subscribe", 0) << ">" << endl
			<< "List-Unsubscribe: <mailto:" <<
			get_verp_return("unsubscribe", 0) << ">" << endl
			<< "List-Post: <mailto:" <<
			cmdget("ADDRESS") << ">" << endl
			<< "List-Owner: <mailto:" <<
			get_verp_return("owner", 0) << ">" << endl
			<< "List-Help: <mailto:" <<
			get_verp_return("help", 0) << ">" << endl;

	}
	return (0);
}

// Set mailing list options

int cmdset(int argc, char **argv)
{
ofstream ofs(OPTIONS ".new");
ifstream ifs(OPTIONS);

	if (!ofs.is_open() || !ifs.is_open())
	{
		perror(OPTIONS);
		return (1);
	}

int i;

	for (i=0; i<argc; i++)
		ofs << argv[i] << endl;

CString	buf;

	while ((buf << ifs) == 0)
	{
	const char *p=buf;
	const char *q=strchr(p, '=');

		if (!q)	continue;

		for (i=0; i<argc; i++)
			if (strncmp(argv[i], p, q-p) == 0 &&
				argv[i][q-p] == '=')
				break;
		if (i < argc)	continue;
		ofs << buf << endl;
	}

	if (ifs.bad() || ofs.bad())
	{
		perror(OPTIONS);
		return (1);
	}

	ofs.close();
	ifs.close();
	if (rename( OPTIONS ".new", OPTIONS))
	{
		perror(OPTIONS);
		return (1);
	}
	return (0);
}

int docmdalias(const char *addr, CString subbuf)
{
CString	buf;
int	rc;

	rc=getinfo(addr, isfound);
	if (rc)
	{
		cerr << "<" << addr
			<< "> is not subscribed to this mailing list." << endl;
		return (9);
	}

CString	a=header(subbuf, "x-alias");

	a.TrimLeft();
	a.TrimRight();

char	*p=a.GetBuffer(-1);

	p=strchr(p, '@');
	while (p && *p)
	{
		*p=tolower( (int)(unsigned char)*p );
		++p;
	}
	a.ReleaseBuffer(-1);

SubExclusiveLock subscription_lock;

DbObj	aliases;

	aliases.Open(ALIASES, "C");

	if (a.GetLength() > 0)
	{
	CString	key;

		key="1";
		key += a;

		if (aliases.Store(key, key.GetLength(),
			addr, strlen(addr), "I"))
		{
			cerr << "<" << a << "> is an existing write-only alias."
				<< endl;
			return (9);
		}

		key="0";
		key += addr;

	size_t	pl;
	char	*p=aliases.Fetch(key, key.GetLength(), pl, "");

		if (p)
		{
		CString	s;
		char	*q=s.GetBuffer(pl+1);

			*q='1';
			memcpy(q+1, p, pl);
			s.ReleaseBuffer(pl+1);

			aliases.Delete(s, pl+1);
			free(p);
		}

		aliases.Store(key, key.GetLength(), a, a.GetLength(), "R");
	}
	else
	{
	CString	key;

		key="0";
		key += addr;

	size_t	pl;
	char	*p=aliases.Fetch(key, key.GetLength(), pl, "");

		if (p)
		{
		CString	s;
		char	*q=s.GetBuffer(pl+1);

			*q='1';
			memcpy(q+1, p, pl);
			s.ReleaseBuffer(pl+1);

			aliases.Delete(s, pl+1);
			free(p);
			aliases.Delete(key, key.GetLength());
		}
	}
	return (0);
}

// List subscribed addresses

int cmdlsub(int argc, char **argv)
{
CString	buf;
SubscriberList subs;

	while (subs.Next(buf) == 0)
	{
		const char *p=subs.sub_info;
		time_t t=0;

		if (strncmp(p, "x-couriermlm-date:", 18) == 0)
		{
			p += 18;
			while (*p && isspace((int)(unsigned char)*p))
				++p;
			while (isdigit((int)(unsigned char)*p))
			{
				t=t * 10 + (*p-'0');
				++p;
			}
			if (t)
			{
				struct tm *tmptr=localtime(&t);
				char tbuf[100];

				if (strftime(tbuf, sizeof(tbuf),
					     "%d-%b-%Y", tmptr) > 0)
				{
					buf += " (";
					buf += tbuf;
					buf += ")";
				}
			}
		}

		cout << buf << endl;
	}
	return (0);
}

static void doexport(ostream &o)
{
CString	buf;
SubscriberList subs;

	while (subs.Next(buf) == 0)
	{
	const char *c;
	int	lastnl=1;

		o << buf << endl;
		for (c=subs.sub_info; c && *c; c++)
		{
			if (*c == '.' && lastnl)
				o << '.';
			o << *c;
			lastnl= *c == '\n';
		}
		if (!lastnl)	o << '\n';
		o << "." << endl;
	}
}

int cmdexport(int argc, char **argv)
{
	doexport(cout);
	return (0);
}

static int doimport(istream &i)
{
CString	address;
CString	subinfo;
CString	linebuf;
int	rc;

	while ( (address << i) == 0)
	{
		subinfo="";

		while ((linebuf << i) == 0)
		{
			if (linebuf == ".")	break;
			if (*(const char *)linebuf == '.')
				linebuf=linebuf.Mid(1);
			subinfo += linebuf;
			subinfo += '\n';
		}

		rc=docmdsub(address, subinfo, false);
		if (rc == 9)
		{
			cout << address << ": already subscribed." << endl;
			rc=0;
		}
		if (rc)	return (rc);
	}
	return (0);
}

int cmdimport(int argc, char **argv)
{
	return (doimport(cin));
}

int cmdlaliases(int argc, char **argv)
{
CString	buf;
SubscriberList subs(1);

	while (subs.Next(buf) == 0)
		cout << buf << ' ' << subs.posting_alias << endl;
	return (0);
}

// Display subscription information for this subscriber


static int print_info(const char *s, size_t l)
{
	cout.write(s, l);
	return (0);
}

int cmdinfo(int argc, char **argv)
{
int	rc=getinfo(argc == 0 ? 0:argv[0], print_info);

	if (rc == EX_NOUSER)
		cerr << "No subscription information found." << endl;
	return (rc);
}
