/***************************************************************************
 *																		 *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or	 *
 *   (at your option) any later version.								   *
 *																		 *
 ***************************************************************************/

/*
 *
  Ricardo Galli <gallir@uib.es>
  This is an attempt to do The Right Thing for SpeedSteps and PPC.
  And also obey strictly to KISS.
 */

#define DYNAMIC			0
#define MIN				1
#define MAX				2

#define POWERSAVE 		0
#define PERFORMANCE 	1
#define THROTTLING_LOW_DEFAULT	3

// the number of powersave tries before changing from performance
#define DECAY		5


typedef unsigned (*cpu_parser_t)(void);
typedef unsigned (*cpu_writer_t)(unsigned);
typedef void (*get_times_t)(unsigned long *, unsigned long *);

// Forward declarations
void get_times_24(unsigned long *, unsigned long *);
void get_times_26(unsigned long *, unsigned long *);
void reset_times();
void usr1_handler(int);
void usr2_handler(int);
void hup_handler(int);

unsigned cpu_parser_24();
unsigned cpu_parser_25();
unsigned cpu_writer_24(unsigned);
unsigned cpu_acpi_24();
unsigned cpu_acpi_writer_24(unsigned);

unsigned cpu_writer_25(unsigned);
inline unsigned cpu_get_state();

unsigned cpu_get_frequencies();
int get_freq_min_index();
