/* ui_init.c - GUI Initialisation
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#include "crank.h"
#include "xpms.h"

/* Global variables */
GtkWidget *textarea; /* Result of the mode plugin goes here - hopefully decrypted text */
GtkWidget *sourcearea; /* Optional area for appearance of source text */
GtkWidget *label_source_area; /* Label for above */
GtkWidget *hbox2; /* The box containing the sourcearea */
GtkWidget *main_vbox;
int displaying_sourcearea = TRUE; /* Whether or not to hide source area */

/* External functions and data */
extern char *text;
extern plugin_data *plugin_list;
extern int number_of_plugins;
extern GtkWidget *current_plugin_widget;
extern plugin_data null_plugin;
void activate_plugin(plugin_data *plugin);
void display_source_text(void);

/* Callbacks */
void cb_exit_crank (GtkWidget *widget, gpointer gdata);
void cb_about (GtkWidget *widget, gpointer gdata);
void cb_set_source_from_view(GtkWidget *widget, gpointer gdata);
void cb_about (GtkWidget *widget, gpointer gdata);
void cb_start_open(GtkWidget *widget, gpointer gdata);
void cb_start_save(GtkWidget *widget, gpointer gdata); 
void cb_call_plugin(GtkWidget *widget, gpointer gdata);
void cb_start_plugin_viewer(GtkWidget *widget, gpointer gdata);
void cb_toggle_source_view(void);
void cb_source_change(GtkEditable *editable, gpointer user_data);
void cb_clear_source(void);

/* Make the menu bar */
static GtkItemFactoryEntry menu_items[] = {
    { "/_File",                        NULL,         NULL,                       0, "<Branch>"},
    { "/File/_Open",                   "<control>O", cb_start_open,              0, NULL },
    { "/File/_Save View As",           "<control>S", cb_start_save,              0, NULL },
    { "/File/E_xit",                   "<control>Q", cb_exit_crank,              0, NULL },
    
    { "/_Source",                      NULL,         NULL,                       0, "<Branch>"},
    { "/Source/_Set Source From View", NULL,         cb_set_source_from_view,    0, NULL},
    { "/Source/_Clear",                NULL,         cb_clear_source,            0, NULL}, 
    { "/Source/_Hide Source Pane",     NULL,         cb_toggle_source_view,      0, "<ToggleItem>"},
    
    { "/_Text",                        NULL,         NULL,                       0, "<Branch>"},
    
    { "/Statistics",                   NULL,         NULL,                       0, "<Branch>"},

    { "/_Utilities",                   NULL,         NULL,                       0, "<Branch>"},

    { "/_Monoalphabetic",              NULL,         NULL,                       0, "<Branch>"},
    
    { "/Transposition",                NULL,         NULL,                       0, "<Branch>"},

    { "/_Plugins",                     NULL,         NULL,                       0, "<Branch>"},
    { "/Plugins/_View Plugins",        NULL,         cb_start_plugin_viewer,     0, NULL}, 
    { "/Plugins/",                     NULL,         NULL,                       0, "<Separator>"},

    { "/_Help",                        NULL,         NULL,                       0, "<LastBranch>"},
    { "/Help/_About",                  NULL,         cb_about,                   0, NULL}
};

static GtkWidget *make_main_menu(GtkWidget *window) {
    GtkWidget *mainmenu;
    GtkItemFactory *item_factory;
    GtkAccelGroup *accel_group;
    GtkItemFactoryEntry *complete_menu_items;
    gint nmenu_items = sizeof (menu_items) / sizeof(menu_items[0]);
    int i, plugin_counter = 0, plugins_menued = 0;
    char *buf;
    plugin_data *plugin_ptr = plugin_list;

   
    complete_menu_items = malloc(sizeof(menu_items[0]) * (nmenu_items + number_of_plugins * 2));
    
    /* Copy static menu to new menu */
    for (i = 0; i < nmenu_items; i++) {
	complete_menu_items[i].path = menu_items[i].path;
	complete_menu_items[i].accelerator = menu_items[i].accelerator;
	complete_menu_items[i].callback = menu_items[i].callback;
	complete_menu_items[i].callback_action = menu_items[i].callback_action;
        complete_menu_items[i].item_type = menu_items[i].item_type;
    }
    while (plugin_ptr && plugin_ptr->plugin_type == PLUGIN_FITNESS)
	plugin_ptr = plugin_ptr->next;
    while (plugin_ptr) {
	buf = malloc(sizeof(char) * (strlen(plugin_ptr->name) + 128));
	sprintf(buf, "/Plugins/%s", plugin_ptr->name);
	complete_menu_items[i].path = buf;
	complete_menu_items[i].accelerator = NULL;
	complete_menu_items[i].callback = cb_call_plugin;
	complete_menu_items[i].callback_action = plugin_counter; /* Zero starting number in list of plugins */
	complete_menu_items[i].item_type = NULL;
	i++;
	complete_menu_items[i].path = plugin_ptr->menu_string;
	complete_menu_items[i].accelerator = NULL;
	complete_menu_items[i].callback = cb_call_plugin;
	complete_menu_items[i].callback_action = plugin_counter; /* Zero starting number in list of plugins */
	complete_menu_items[i].item_type = NULL;
        i++;	
	plugin_counter++;
	plugins_menued++;	    
	plugin_ptr = plugin_ptr->next;
	while (plugin_ptr && plugin_ptr->plugin_type == PLUGIN_FITNESS) {
	    plugin_counter++;
	    plugin_ptr = plugin_ptr->next;
	}
    }
    accel_group = gtk_accel_group_new();
    item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accel_group);
    gtk_item_factory_create_items(item_factory, nmenu_items + plugins_menued * 2, complete_menu_items, NULL);
    gtk_window_add_accel_group (GTK_WINDOW(window), accel_group);
    mainmenu = gtk_item_factory_get_widget(item_factory, "<main>");
    return mainmenu;
}

static GtkWidget *make_toolbar(GtkWidget *window) {
    GtkWidget *toolbar;
    GdkPixmap *icon;
    GtkWidget *iconw;
    GdkBitmap *mask;
    
    toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,
                              GTK_TOOLBAR_BOTH);
    gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar), GTK_RELIEF_NONE);
    gtk_toolbar_set_space_size(GTK_TOOLBAR(toolbar), 2);

    /* New */
    icon = gdk_pixmap_create_from_xpm_d(window->window, &mask, 
					&window->style->white, new_xpm); 
    iconw = gtk_pixmap_new(icon, mask); 
    gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), "New", "Clear source pane", "Private", 
			    iconw, cb_clear_source, NULL);
    /* Open */
    icon = gdk_pixmap_create_from_xpm_d(window->window, &mask, 
					&window->style->white, open_xpm); 
    iconw = gtk_pixmap_new(icon, mask); 
    gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), "Open", "Open into source pane", "Private", 
			    iconw, cb_start_open, NULL);
    /* Save */
    icon = gdk_pixmap_create_from_xpm_d(window->window, &mask, 
					&window->style->white, save_xpm); 
    iconw = gtk_pixmap_new(icon, mask); 
    gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), "Save", "Save from view pane", "Private", 
			    iconw, cb_start_save, NULL);
    gtk_widget_show(toolbar);
    /* Source = View */
    icon = gdk_pixmap_create_from_xpm_d(window->window, &mask, 
					&window->style->white, arrows_ver_xpm); 
    iconw = gtk_pixmap_new(icon, mask); 
    gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), "Equate", "Set source pane to be same as view pane", "Private", 
			    iconw, cb_set_source_from_view, NULL);


    return toolbar;
}
void build_gui(void) {
    GtkWidget *window;
    GtkWidget *menu;
    GtkWidget *hbox1;    
    GtkWidget *vscrollbar1;
    GtkWidget *vscrollbar2;
    GtkWidget *label_text_area;
    GtkWidget *hseparator, *hseparator2;
    GtkWidget *toolbar;

    /* Main window */
    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window), "Crank v" VERSION);
    gtk_window_set_policy(GTK_WINDOW(window), FALSE, TRUE, FALSE);
    gtk_widget_set_usize(window, -1, -1);
    gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(cb_exit_crank), NULL);
    gtk_widget_realize(window);

    /* Main vertical box */
    main_vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(window), main_vbox); 
    gtk_widget_show(main_vbox);
   
    /* Main menu */
    menu = make_main_menu(window);
    gtk_box_pack_start(GTK_BOX(main_vbox), menu, FALSE, TRUE, 0);
    gtk_widget_show(menu);

    /* Toolbar */
    toolbar = make_toolbar(window);
    gtk_box_pack_start(GTK_BOX(main_vbox), toolbar, FALSE, FALSE, 0);
    gtk_widget_show(toolbar);

    /* Seperator to keep plugin widgets seperate from display */
    hseparator = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(main_vbox), hseparator, FALSE, FALSE, 0);
    gtk_widget_show(hseparator);

    /* Seperator to keep plugin widgets seperate from display */
    hseparator2 = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(main_vbox), hseparator2, FALSE, FALSE, 0);
    gtk_widget_show(hseparator2);
    
    /* Text areas */
    label_source_area = gtk_label_new("Source");
    gtk_box_pack_start(GTK_BOX(main_vbox), label_source_area, FALSE, FALSE, 0);
    gtk_widget_show(label_source_area);
    hbox2 = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(main_vbox), hbox2, TRUE, TRUE, 0);
    gtk_widget_show(hbox2);
    sourcearea = gtk_text_new(NULL, NULL);
    gtk_text_set_editable(GTK_TEXT(sourcearea), TRUE);
    gtk_box_pack_start(GTK_BOX(hbox2), sourcearea, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(sourcearea), "changed", GTK_SIGNAL_FUNC(cb_source_change), NULL);

    label_text_area = gtk_label_new("View");
    gtk_box_pack_start(GTK_BOX(main_vbox), label_text_area, FALSE, FALSE, 0);
    gtk_widget_show(label_text_area);
    hbox1 = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(main_vbox), hbox1, TRUE, TRUE, 0);
    gtk_widget_show(hbox1);
    textarea = gtk_text_new(NULL, NULL);
    gtk_text_set_editable(GTK_TEXT(textarea), FALSE);
    gtk_box_pack_start(GTK_BOX(hbox1), textarea, TRUE, TRUE, 0);

    vscrollbar1 = gtk_vscrollbar_new (GTK_TEXT(textarea)->vadj);
    gtk_box_pack_start(GTK_BOX(hbox1), vscrollbar1, FALSE, FALSE, 0);
    vscrollbar2 = gtk_vscrollbar_new (GTK_TEXT(sourcearea)->vadj);
    gtk_box_pack_start(GTK_BOX(hbox2), vscrollbar2, FALSE, FALSE, 0);
   
    gtk_widget_show(vscrollbar1);
    gtk_widget_show(vscrollbar2);
    gtk_widget_show(textarea);
    gtk_widget_show(sourcearea);
    gtk_widget_show(window);

    /* Initial text */
    text = malloc(sizeof(char)); 
    text[0] = '\0';
    display_source_text();
        
    /* Activate a null plugin to start off */
    activate_plugin(&null_plugin);

}
