"=====================================================================
" cream-email-formatter.vim
"
" Cream -- An easy-to-use configuration of the famous Vim text editor
" [ http://cream.sourceforge.net ] Copyright (C) 2001-2006  Steve Hall
"
" License:
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
" [ http://www.gnu.org/licenses/gpl.html ]
"
" This program is distributed in the hope that it will be useful, but
" WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
" General Public License for more details.
"
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
" 02111-1307, USA.
"
"
" Description:
" Mail clients destroy proper formatting, this script puts them back.
"


" register as a Cream add-on
if exists("$CREAM")

	call Cream_addon_register(
	\ 'Email Prettyfier',
	\ "Re-format email to \"proper\" form.",
	\ "Re-format email to \"proper\" form. (Currently only expands compressed >>> to > > > .)",
	\ '&Email Prettyfier',
	\ 'call Cream_email_formatter()',
	\ '<Nil>'
	\ )
endif

function! Cream_email_formatter()
" re-format email to "proper" form.

	" if filetype not Vim, quit
	if &filetype != "txt" &&
	\  &filetype != "mail" &&
	\  &filetype != ""
		call confirm(
			\ "Function designed only for text files. Please check this document's filetype.\n" .
			\ "\n", "&Ok", 1, "Info")
		return
	endif

	" fold all functions
	"" TODO:
	"" o a little regexp help here, please?
	"" o Combinations of spaces and > disrupt (regexp would fix?)
	"silent! %substitute/^>>>>>>>>>> /> > > > > > > > > > /gei
	"silent! %substitute/^>>>>>>>>>>/> > > > > > > > > > /gei
	"silent! %substitute/^>>>>>>>>> /> > > > > > > > > /gei
	"silent! %substitute/^>>>>>>>>>/> > > > > > > > > /gei
	"silent! %substitute/^>>>>>>>> /> > > > > > > > /gei
	"silent! %substitute/^>>>>>>>>/> > > > > > > > /gei
	"silent! %substitute/^>>>>>>> /> > > > > > > /gei
	"silent! %substitute/^>>>>>>>/> > > > > > > /gei
	"silent! %substitute/^>>>>>> /> > > > > > /gei
	"silent! %substitute/^>>>>>>/> > > > > > /gei
	"silent! %substitute/^>>>>> /> > > > > /gei
	"silent! %substitute/^>>>>>/> > > > > /gei
	"silent! %substitute/^>>>> /> > > > /gei
	"silent! %substitute/^>>>>/> > > > /gei
	"silent! %substitute/^>>> /> > > /gei
	"silent! %substitute/^>>>/> > > /gei
	"silent! %substitute/^>> /> > /gei
	"silent! %substitute/^>>/> > /gei
	"silent! %substitute/^>\([^ ]\)/> \1/gei

	let i = 0
	while i < 10
		" need spaces
		silent! %substitute/^[ >]*\zs\(>\) \@!/\1 /ge
		" but not too many!
		silent! %substitute/^[> ]*\zs\(>\)  \+/\1 /ge
		let i = i + 1
	endwhile

	" strip out bracketed email addresses (<name@domain.com>)
	%substitute/\s*<[a-zA-Z0-9_\.\-]\+@[a-zA-Z0-9\-]\+\.[a-zA-Z0-9]\{2,4}>//gei
	" spam-proof other email addresses
	%substitute/\([a-zA-Z0-9_\.\-]\+\)@\([a-zA-Z0-9\-]\+\)\.\([a-zA-Z0-9]\{2,4}\)/\1 \2 \3/gei


	" change header formatting
	let str = ""
	let str = str . "\n"
	let str = str . "Simplify email headers?\n"
	let str = str . "\n"
	let str = str . "     __________________________________________\n"
	let str = str . "     Option 1\n"
	let str = str . "                              From: (name)\n"
	let str = str . "                              To: (name)\n"
	let str = str . "                              Cc: (names)\n"
	let str = str . "                              Sent: (date)\n"
	let str = str . "                              Subject: (text)\n"
	let str = str . "     to\n"
	let str = str . "                              From: (name), (date)\n"
	let str = str . "\n"
	let str = str . "     __________________________________________\n"
	let str = str . "     Option 2\n"
	let str = str . "                              From: (name)\n"
	let str = str . "                              To: (name)\n"
	let str = str . "                              Cc: (names)\n"
	let str = str . "                              Sent: (date)\n"
	let str = str . "                              Subject: (text)\n"
	let str = str . "     to\n"
	let str = str . "                              By: (name)\n"
	let str = str . "                              To: (name)\n"
	let str = str . "                              Cc: (names)\n"
	let str = str . "                              On: (date)\n"
	let str = str . "                              Re: (text)\n"
	let n = confirm(str .
		\ "\n", "Option1\nOption2\n&Cancel", 1, "Info")
	if     n == 1
		" Change
		"
		"    From: (name)
		"    To: (name)
		"    Cc: (name)
		"    Sent: (date)
		"
		" (and leading quote ">" chars) to
		"
		"    From: (name), (date)
		"
		"silent! %substitute/^\([> ]*\)\(From: \|By: \)\(.\{2,}\)\n[> ]*[To: ]*[[:print:]]*\n\=[> ]*\(Sent:\|On:\|Date:\)/\1\2\3,/geI
		silent! %substitute/^\([> ]*\)\(From: \|By: \)\(.\{2,}\)\n\([> ]*[To: ]*[[:print:]]*\n\)\=\([> ]*[Cc: ]*[[:print:]]*\n\)\=\([> ]*[Subject: ]*[[:print:]]*\n\)\=[> ]*\(Sent:\|On:\|Date:\)/\1\2\3,/geI
		" remove stray "To: (name)" lines
		silent! %substitute/^\([> ]*\)To:\(.\+\)\n//geI
		" remove stray "Subject: (text)" lines
		silent! %substitute/^\([> ]*\)\(Subject:\|Re:\)\(.\+\)\n//geI
		" remove stray "Cc: (names)" lines
		silent! %substitute/^\([> ]*\)\(CC:\|Cc:\|cc:\)\(.\+\)\n//geI
	elseif n == 2
		" Change
		"
		"    From: (name)
		"    Sent: (date)
		"    To: (name)
		"    Subject: (text)
		"
		" (and leading quote ">" chars) to
		"
		"    By: (name)
		"    On: (date)
		"    To: (name)
		"    Cc: (name)
		"    Re: (text)
		"
		silent! %substitute/^\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=From: \(.\+\)$/\1\2\3\4\5\6\7\8By: \9/geI
		"silent! %substitute/^\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=Cc: \(.\+\)$/\1\2\3\4\5\6\7\8Cc: \9/geI
		silent! %substitute/^\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=Sent: \(.\+\)$/\1\2\3\4\5\6\7\8On: \9/geI
		silent! %substitute/^\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=Date: \(.\+\)$/\1\2\3\4\5\6\7\8On: \9/geI
		silent! %substitute/^\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=\(> \)\=Subject: \(.\+\)$/\1\2\3\4\5\6\7\8Re: \9/geI
	else
		" Cancel
	endif

	" condense all empty lines
	call Cream_emptyline_collapse()


endfunction

