/*
 *  declarations for filesytem-related utilities for cryptmount
 *  $Revision: 130 $, $Date: 2006-10-15 11:42:36 +0100 (Sun, 15 Oct 2006) $
 *  Copyright 2005-2006, RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exemption, permission is granted to link cryptmount
    with the OpenSSL project's "OpenSSL" library and distribute
    the linked code without invoking clause 2(b) of the GNU GPL version 2.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with cryptmount; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef _FSUTILS_H
#define _FSUTILS_H

struct cment;

int parse_fsoptions(const char *buff, unsigned long *mflags);
int fs_check(const char *dev, const struct cment *ent);
int fs_mount(const char *dev, const struct cment *ent);
int fs_unmount(const struct cment *ent);
int fs_swapon(const char *dev, const struct cment *ent);
int fs_swapoff(const struct cment *ent);
int is_mounted(const struct cment *ent);
int is_readonlyfs(const char *path);

#endif  /* _FSUTILS_H */

/*
 *  fsutils.h
 *  (C)Copyright 2005-2006, RW Penney
 */
