/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#include <wx/wx.h>
#include <wx/wizard.h>
#include <wx/filedlg.h>
#include <wx/filename.h>
#include <wx/file.h>

#include "../pkcs10.hh"
#include "../pkcs8.hh"
#include "../Utils.hh"
#include "Common.hh"
#include "CertificateRequestWizard.hh"

#ifndef __WXMSW__
#include "pics/wiz1.xpm"
#include "pics/add_contact.xpm"
#include "pics/folder_mini.xpm"
#include "pics/users.xpm"
#include "pics/mykeys.xpm"
#include "pics/add.xpm"
#include "pics/verify_ok.xpm"
#endif


using namespace Cryptonit;


BEGIN_EVENT_TABLE(CertificateRequestWizard::UserInformations, wxWizardPageSimple)
    EVT_WIZARD_PAGE_CHANGING(-1, CertificateRequestWizard::UserInformations::onWizardPageChanging)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(CertificateRequestWizard::OrganizationInformations, wxWizardPageSimple)
    EVT_WIZARD_PAGE_CHANGING(-1, CertificateRequestWizard::OrganizationInformations::onWizardPageChanging)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(CertificateRequestWizard::OptionnalAttributes, wxWizardPageSimple)
    EVT_WIZARD_PAGE_CHANGING(-1, CertificateRequestWizard::OptionnalAttributes::onWizardPageChanging)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(CertificateRequestWizard::PrivateKeyPasswordAlgorithm, wxWizardPageSimple)
    EVT_WIZARD_PAGE_CHANGING(-1, CertificateRequestWizard::PrivateKeyPasswordAlgorithm::onWizardPageChanging)
    EVT_TEXT(CRW_PASS_FIRST_TC, CertificateRequestWizard::PrivateKeyPasswordAlgorithm::check)
    EVT_TEXT(CRW_PASS_TC, CertificateRequestWizard::PrivateKeyPasswordAlgorithm::check)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(CertificateRequestWizard::OutputFile, wxWizardPageSimple)
    EVT_WIZARD_PAGE_CHANGING(-1, CertificateRequestWizard::OutputFile::onWizardPageChanging)
    EVT_BUTTON( CRW_OUTPUT_FILE_BTN, CertificateRequestWizard::OutputFile::onFileBtnClick)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(CertificateRequestWizard::Summary, wxWizardPageSimple)
    EVT_WIZARD_PAGE_CHANGED(-1, CertificateRequestWizard::Summary::onWizardPageChanged)
    EVT_WIZARD_PAGE_CHANGING(-1, CertificateRequestWizard::Summary::onWizardPageChanging)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(CertificateRequestWizard::Process, wxWizardPageSimple)
    EVT_WIZARD_PAGE_CHANGED(-1, CertificateRequestWizard::Process::onWizardPageChanged)
    EVT_IDLE(CertificateRequestWizard::Process::onIdle)
    EVT_WIZARD_PAGE_CHANGING(-1, CertificateRequestWizard::Process::onWizardPageChanging)
END_EVENT_TABLE()


/*** UserInformation ***/
CertificateRequestWizard::UserInformations::UserInformations(wxWizard* parent)
    : wxWizardPageSimple( parent )
{
    wxPanel *panel = new wxPanel( this );


    wxBoxSizer *mainSizer = new wxBoxSizer( wxVERTICAL );
    wxBoxSizer *titleSizer = new wxBoxSizer( wxHORIZONTAL );
    wxFlexGridSizer* sizer = new wxFlexGridSizer( 2, 9 );


    wxBitmap userIcon = wxBITMAP(add_contact);
#ifdef __WXMSW__
    userIcon.SetMask( new wxMask(userIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif

    titleSizer->Add( new wxStaticBitmap(panel, -1, userIcon ),
		0,  wxALIGN_CENTER_VERTICAL | wxALL, 4);
    titleSizer->Add( new wxStaticText(panel, -1, _("Enter in the fields below your personnal information.")),
		1,  wxALIGN_CENTER_VERTICAL | wxALIGN_LEFT | wxALL, 4);
    


    sizer->Add( new wxStaticText(panel, -1, _("First name")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcFirstname = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("Last name")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcLastname = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("Title")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcTitle = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("Display name")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcDisplayname = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("Nickname")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcNickname = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 5);

    sizer->Add( new wxStaticText(panel, -1, _("Email")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcEmail = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("Additional Email")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcEmail2 = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("Screen Name")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcScreenname = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    mainSizer->Add( titleSizer , 0 , wxALL , 6);
    mainSizer->Add( sizer );

    panel->SetSizer( mainSizer );
    mainSizer->Fit( panel );
}



void CertificateRequestWizard::UserInformations::onWizardPageChanging(wxWizardEvent& event)
{
    if( tcFirstname->GetValue() == wxEmptyString ) {
	wxString msg = _("You must provide at least a First name");
	wxMessageBox( msg, _("Not allowed"),
		      wxICON_WARNING | wxOK, this);
	event.Veto();
    }
    else {
	infos.clear();
	
	std::pair< std::pair< wxString, wxString >, wxString > entry;
	    
	if( tcFirstname->GetValue() != wxEmptyString ) {
	    entry.second = tcFirstname->GetValue();
	    entry.first.first = _T("commonName");
	    entry.first.second = _("First name");
	    infos.push_back(entry);
	}
	if( tcLastname->GetValue() != wxEmptyString ) {
	    entry.second = tcLastname->GetValue();
	    entry.first.first = _T("sn");
	    entry.first.second = _("Last name");
	    infos.push_back(entry);
	}
	if( tcTitle->GetValue() != wxEmptyString ) {
	    entry.second = tcTitle->GetValue();
	    entry.first.first = _T("title");
	    entry.first.second = _("Title");
	    infos.push_back(entry);
	}
	if( tcDisplayname->GetValue() != wxEmptyString ) {
	    entry.second = tcDisplayname->GetValue();
	    entry.first.first = _T("name");
	    entry.first.second = _("Display name");
	    infos.push_back(entry);
	}
	if( tcNickname->GetValue() != wxEmptyString ) {
	    entry.second = tcNickname->GetValue();
	    entry.first.first = _T("givenName");
	    entry.first.second = _("Nickname");
	    infos.push_back(entry);
	}
	if( tcEmail->GetValue() != wxEmptyString ) {
	    entry.second = tcEmail->GetValue();
	    entry.first.first = _T("emailAddress");
	    entry.first.second = _("Email");
	    infos.push_back(entry);
	}
	if( tcEmail2->GetValue() != wxEmptyString ) {
	    entry.second = tcEmail2->GetValue();
	    entry.first.first = _T("mail2");
	    entry.first.second = _("Additionnal Email");
	    infos.push_back(entry);
	}
	if( tcScreenname->GetValue() != wxEmptyString ) {
	    entry.second = tcScreenname->GetValue();
	    entry.first.first = _T("displayName");
	    entry.first.second = _("Screen Name");
	    infos.push_back(entry);
	}

    }

}



/*** OrganizationInformations ***/
CertificateRequestWizard::OrganizationInformations::OrganizationInformations(wxWizard* parent)
    : wxWizardPageSimple( parent )
{
    wxPanel *panel = new wxPanel( this );

    wxBoxSizer *mainSizer = new wxBoxSizer( wxVERTICAL );
    wxBoxSizer *titleSizer = new wxBoxSizer( wxHORIZONTAL );

    wxFlexGridSizer* sizer = new wxFlexGridSizer( 2, 10 );


    wxBitmap orgIcon = wxBITMAP(users);
#ifdef __WXMSW__
    orgIcon.SetMask( new wxMask(orgIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif

    titleSizer->Add( new wxStaticBitmap(panel, -1, orgIcon ),
		0,  wxALIGN_CENTER_VERTICAL | wxALL, 4);
    titleSizer->Add( new wxStaticText(panel, -1, _("Enter in the fields below your organization relative information.")),
		1,  wxALIGN_CENTER_VERTICAL | wxALIGN_LEFT | wxALL, 4);



    sizer->Add( new wxStaticText(panel, -1, _("Organization")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcOrganization = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("Department")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcDepartment = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("Address")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcAddress = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, wxEmptyString),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcAddress2 = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("City")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcCity = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("State/Province")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcState = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("Zip/Postal Code")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcZip = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("Country")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcCountry = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);

    sizer->Add( new wxStaticText(panel, -1, _("Web Page")),
		1, wxALIGN_LEFT | wxALL, 2);
    sizer->Add( tcWebpage = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		0, wxALIGN_LEFT | wxALL, 2);


    mainSizer->Add( titleSizer , 0 , wxALL , 6);
    mainSizer->Add( sizer );

    panel->SetSizer( mainSizer );
    mainSizer->Fit( panel );


}



void CertificateRequestWizard::OrganizationInformations::onWizardPageChanging(wxWizardEvent& event)
{
    std::pair< std::pair< wxString, wxString >, wxString > entry;
    infos.clear();
	    
    if( tcOrganization->GetValue() != wxEmptyString ) {
	entry.second = tcOrganization->GetValue();
	entry.first.first = _T("organizationName");
	entry.first.second = _("Organization");
	infos.push_back(entry);
    }
    if( tcDepartment->GetValue() != wxEmptyString ) {
	entry.second = tcDepartment->GetValue();
	entry.first.first = _T("organizationalUnitName");
	entry.first.second = _("Department");
	infos.push_back(entry);
    }
    if( tcAddress->GetValue() != wxEmptyString ) {
	entry.second = tcAddress->GetValue();
	entry.first.first = _T("street");
	entry.first.second = _("Address");
	infos.push_back(entry);
    }
    if( tcAddress2->GetValue() != wxEmptyString ) {
	entry.second = tcAddress2->GetValue();
	entry.first.first = _T("street2");
	entry.first.second = wxEmptyString;
	infos.push_back(entry);
    }
    if( tcCity->GetValue() != wxEmptyString ) {
	entry.second = tcCity->GetValue();
	entry.first.first = _T("localityName");
	entry.first.second = _("City");
	infos.push_back(entry);
    }
    if( tcState->GetValue() != wxEmptyString ) {
	entry.second = tcState->GetValue();
	entry.first.first = _T("stateOrProvinceName");
	entry.first.second = _("State/Province");
	infos.push_back(entry);
    }
    if( tcZip->GetValue() != wxEmptyString ) {
	entry.second = tcZip->GetValue();
	entry.first.first = _T("postalCode");
	entry.first.second = _("Zip/Postal Code");
	infos.push_back(entry);
    }
    if( tcCountry->GetValue() != wxEmptyString ) {
	entry.second = tcCountry->GetValue();
	entry.first.first = _T("countryName");
	entry.first.second = _("Country");
	infos.push_back(entry);
    }
    if( tcWebpage->GetValue() != wxEmptyString ) {
	entry.second = tcWebpage->GetValue();
	entry.first.first = _T("www");
	entry.first.second = _("Web Page");
	infos.push_back(entry);
    }
}



/*** PrivateKeyPasswordAlgorithm ***/
CertificateRequestWizard::PrivateKeyPasswordAlgorithm::PrivateKeyPasswordAlgorithm(wxWizard* parent)
    : wxWizardPageSimple( parent )
{
    passphrase = wxEmptyString;
    algorithm = wxEmptyString;
    prettyAlgorithm = wxEmptyString;
    keySize = 2048;

    wxPanel *panel = new wxPanel( this );

    wxBoxSizer *mainSizer = new wxBoxSizer( wxVERTICAL );
    wxBoxSizer *titleSizer = new wxBoxSizer( wxHORIZONTAL );
    wxFlexGridSizer* sizer = new wxFlexGridSizer( 2, 3 );
    

    wxBitmap keyIcon = wxBITMAP(mykeys);
    keyIcon.SetMask( new wxMask(keyIcon, wxColour(0xC0,0xC0,0xC0)) );

    titleSizer->Add( new wxStaticBitmap(panel, -1, keyIcon ),
		0,  wxALIGN_CENTER_VERTICAL | wxALL, 4);
    titleSizer->Add( new wxStaticText(panel, -1, _("Select the encryption algorithm for your private key and his password.")),
		1,  wxALIGN_CENTER_VERTICAL | wxALIGN_LEFT | wxALL, 4);
    

    /* Algorithm */
    sizer->Add( new wxStaticText(panel, -1, _("Encryption algorithm: ")),
		1, wxALIGN_LEFT | wxALL, 6);
    ciphers = getAllCiphers();
    wxString cipherList[ ciphers.size() ];

    std::vector< std::pair < std::string, std::string > >::iterator it;
    unsigned int i = 0;
    for( it = ciphers.begin(); it != ciphers.end(); it++, i++ ) {
				cipherList[i] = std2wx(it->first);
    }

    cbCipher = new wxComboBox( panel, -1, cipherList[0], wxDefaultPosition, wxSize(250,20),
			     ciphers.size(), cipherList, wxCB_DROPDOWN | wxCB_READONLY);
    cbCipher->SetSelection(0);
    sizer->Add( cbCipher,
		0, wxALIGN_LEFT | wxALL, 6);


    /* Key Size */
    sizer->Add( new wxStaticText(panel, -1, _("Key size in bits \n(a size of 2048 bits is recommended): ")),
		0, wxALIGN_LEFT | wxALL, 6);
    tcKeySize = new wxTextCtrl(panel, -1, _T("2048"), wxDefaultPosition, wxSize(250, 20));
    sizer->Add( tcKeySize,
		0, wxALIGN_LEFT | wxALL, 6);
    

    /* Passphrase */
    sizer->Add( new wxStaticText(panel, -1, _("Private key passphrase: ")),
		1, wxALIGN_LEFT | wxALL, 6);
    tcPassphraseFirst = new wxTextCtrl(panel, CRW_PASS_FIRST_TC, wxEmptyString, wxDefaultPosition, wxSize(250, 20), wxTE_PASSWORD); 
    sizer->Add( tcPassphraseFirst, 0, wxALIGN_LEFT | wxALL, 6);

    sizer->Add( new wxStaticText(panel, -1, _("Retype your passphrase: ")),
		1, wxALIGN_LEFT | wxALL, 6);
    tcPassphrase = new wxTextCtrl(panel, CRW_PASS_TC, wxEmptyString, wxDefaultPosition, wxSize(250, 20), wxTE_PASSWORD); 
    sizer->Add( tcPassphrase, 0, wxALIGN_LEFT | wxALL, 6);

    sizer->Add( new wxStaticText(panel, -1, wxEmptyString), 1, wxALIGN_LEFT | wxALL, 6);
    passphraseValid = new wxStaticText(panel, -1, wxEmptyString);
    wxFont font = passphraseValid->GetFont();
    font.SetWeight(wxBOLD);
    passphraseValid->SetFont( font );
    sizer->Add( passphraseValid, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 6);


    mainSizer->Add( titleSizer , 0 , wxALL , 6);
    mainSizer->Add( sizer );

    panel->SetSizer( mainSizer );
    mainSizer->Fit( panel );
}



void CertificateRequestWizard::PrivateKeyPasswordAlgorithm::onWizardPageChanging(wxWizardEvent& event)
{

    if( event.GetDirection()){
	unsigned long buffer;
	
	if( tcPassphrase->GetValue() == wxEmptyString ) {
	    wxMessageBox(_("You must provide a passphrase for your private key"), _("Not allowed"),
			 wxICON_WARNING | wxOK, this);
	    event.Veto();
	}
	else if ( tcKeySize->GetValue() == wxEmptyString 
		  || tcKeySize->GetValue().IsNumber() == false 
		  || tcKeySize->GetValue().ToULong( &buffer ) == false ) {
	    wxMessageBox(_("You must provide a valid key size for your private key"), _("Not allowed"),
			 wxICON_WARNING | wxOK, this);
	    event.Veto();
	}
	else if ( tcPassphraseFirst->GetValue() != tcPassphrase->GetValue() ) {
	    wxMessageBox(_("Your passphrase is incorrect"), _("Not allowed"),
			 wxICON_WARNING | wxOK, this);
	    event.Veto();
	}
	else {
	    passphrase = tcPassphrase->GetValue();
	    algorithm = std2wx(ciphers[ cbCipher->GetSelection() ].second);
	    prettyAlgorithm = std2wx(ciphers[ cbCipher->GetSelection() ].first);
	    tcKeySize->GetValue().ToULong( &buffer );
	    keySize = (int) buffer;
	}
    }
}



void CertificateRequestWizard::PrivateKeyPasswordAlgorithm::check(wxCommandEvent& event)
{
    if( tcPassphraseFirst->GetValue() == tcPassphrase->GetValue() )
	passphraseValid->SetLabel( _("Passphrase is correct") );
    else
	passphraseValid->SetLabel( _("Passphrase is incorrect") );
}



/*** OutputFile ***/
CertificateRequestWizard::OutputFile::OutputFile(wxWizard* parent)
    : wxWizardPageSimple( parent )
{
    filename = wxEmptyString;

    wxPanel *panel = new wxPanel( this );

    wxBoxSizer* mainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* titleSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* fileSizer = new wxBoxSizer(wxHORIZONTAL);

    wxBitmap userIcon = wxBITMAP(add_contact);
#ifdef __WXMSW__
    userIcon.SetMask( new wxMask(userIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif

    wxBitmap dirIcon = wxBITMAP(folder_mini);
#ifdef __WXMSW__
    dirIcon.SetMask( new wxMask(dirIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif

    titleSizer->Add( new wxStaticBitmap(panel, -1, userIcon ),
		     0, wxALIGN_CENTER_VERTICAL | wxALL, 4);
    titleSizer->Add( new wxStaticText(panel, -1, _("Select the output file for the certificate request: ")),
		     1, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 4);


    tcFilename = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(400, 20));
    fileSizer->Add( tcFilename,
		    1, wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);
    fileSizer->Add( new wxBitmapButton(panel, CRW_OUTPUT_FILE_BTN, dirIcon),
		    0, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);


    mainSizer->Add( titleSizer, 0, wxALL, 6 );
    mainSizer->Add( fileSizer );
    panel->SetSizer( mainSizer );
    mainSizer->Fit( panel );
}


void CertificateRequestWizard::OutputFile::onWizardPageChanging(wxWizardEvent& event)
{
    if( event.GetDirection() ){
	if( tcFilename->GetValue() == wxEmptyString ) {
	    wxMessageBox(_("You must provide a filename for your private key"), _("Not allowed"),
			 wxICON_WARNING | wxOK, this);
	    event.Veto();
	}
	else {
	    wxFileName buffer( tcFilename->GetValue() );
	    if( buffer.GetPath(wxPATH_GET_VOLUME) == wxEmptyString ) {
		// if no dir was provided, prepend it the cwd
		buffer=wxMyPrepend(buffer, wxGetCwd() );
	    }
	    filename = buffer.GetFullPath();
	}
    }
}

void CertificateRequestWizard::OutputFile::onFileBtnClick(wxCommandEvent& WXUNUSED(event))
{
    bool loop = false;

    wxFileDialog fileDlg(this,_("Choose certificate request destination"),wxGetCwd(), _T(""),
												 _T("PEM encoded certificate request (*.pem)|*.pem"),
												 wxSAVE | wxCHANGE_DIR);

    do {
	if(fileDlg.ShowModal() == wxID_OK) {
	    wxFileName certFilename(fileDlg.GetFilename());
	    certFilename=wxMyPrepend(certFilename,fileDlg.GetDirectory());
	    
	    tcFilename->SetValue(certFilename.GetFullPath());

	    if( certFilename.FileExists() ) {
		wxMessageDialog question(this,
					 _("The file specified already exists, do you want to overwrite it? "), 
					 _("Question"),
					 wxICON_EXCLAMATION | wxYES_NO);

		if( question.ShowModal() != wxID_YES )
		    loop = true;
		else
		    loop = false;
	    }
	}

    } while( loop );
}



/*** Optionnal Attributes ***/
CertificateRequestWizard::OptionnalAttributes::OptionnalAttributes(wxWizard *parent)
    : wxWizardPageSimple( parent )
{
    wxPanel* panel = new wxPanel( this );

    wxBoxSizer *mainSizer = new wxBoxSizer( wxVERTICAL );
    wxBoxSizer *titleSizer = new wxBoxSizer( wxHORIZONTAL );
    wxFlexGridSizer* sizer = new wxFlexGridSizer( 2, 2 );

    wxBitmap keyIcon = wxBITMAP(mykeys);
    keyIcon.SetMask( new wxMask(keyIcon, wxColour(0xC0,0xC0,0xC0)) );


    titleSizer->Add( new wxStaticBitmap(panel, -1, keyIcon ),
		     0,  wxALIGN_CENTER_VERTICAL | wxALL, 4);
    titleSizer->Add( new wxStaticText(panel, -1, _("Enter an optional challenge password for this certificate request.")),
		1,  wxALIGN_CENTER_VERTICAL | wxALIGN_LEFT | wxALL, 4);


    sizer->Add( new wxStaticText(panel, -1, _("Challenge password")),
		0, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);
    sizer->Add( new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20)),
		1, wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);


    mainSizer->Add( titleSizer , 0 , wxALL , 6);
    mainSizer->Add( sizer );

    panel->SetSizer( mainSizer );
    mainSizer->Fit( panel );
    
}

void CertificateRequestWizard::OptionnalAttributes::onWizardPageChanging(wxWizardEvent& event)
{
}




/*** Summary ***/
CertificateRequestWizard::Summary::Summary(wxWizard* parent, 
					   UserInformations* user,
					   OrganizationInformations* organization,
					   PrivateKeyPasswordAlgorithm* key,
					   OutputFile* file)
     : wxWizardPageSimple( parent )
{
    userInformations = user;
    organizationInformations = organization;
    privateKey = key;
    outputFile = file;
}



void CertificateRequestWizard::Summary::onWizardPageChanged( wxWizardEvent& event )
{
    wxPanel* panel = new wxPanel( this );

    wxBoxSizer* summarySizer = new wxBoxSizer( wxVERTICAL );

//    wxBoxSizer* title = new wxBoxSizer( wxHORIZONTAL );
    wxStaticText *titleText = new wxStaticText( panel , -1 , _("Please check that information displayed below are correct."));
    wxFont font = titleText->GetFont();
    font.SetWeight(wxBOLD);
    titleText->SetFont( font );

    summarySizer->Add( titleText , 1 ,  wxALL , 4 );

    /* User Informations */
    wxBoxSizer *userTitleSizer = new wxBoxSizer( wxHORIZONTAL );
    wxStaticText* userTitleText = new wxStaticText(panel, -1, _("User information: "));
    font = userTitleText->GetFont();
    font.SetWeight(wxBOLD);
    userTitleText->SetFont( font );

    wxBitmap userIcon = wxBITMAP(add_contact);
#ifdef __WXMSW__
    userIcon.SetMask( new wxMask(userIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif
    
    userTitleSizer->Add( new wxStaticBitmap(panel, -1, userIcon ),
			 0,  wxALIGN_CENTER_VERTICAL | wxALL, 4);
    userTitleSizer->Add( userTitleText, 1,    wxALIGN_CENTER_VERTICAL | wxALIGN_LEFT | wxALL, 4);
    
    wxBoxSizer* userSizer = new wxBoxSizer(wxVERTICAL);


    std::vector< std::pair< std::pair< wxString, wxString >, wxString > >::iterator it = userInformations->infos.begin();
    int i=0;
    while( it != userInformations->infos.end() && i < 2 ){
	wxString buffer;
	if( it->first.first == _T("commonName") ||  it->first.first == _T("sn") ){
	    buffer << it->first.second << _(": ") << it->second;
	    userSizer->Add( new wxStaticText( panel, -1, buffer ), 1, wxEXPAND | wxALIGN_LEFT | wxALL, 2 );
	}
	i++;
	it++;
    }
    summarySizer->Add( userTitleSizer , 0 , wxEXPAND  | wxALL, 2);
    summarySizer->Add( userSizer , 0 , wxEXPAND  | wxALL, 2);
    


     /* Organization Informations */
    wxBoxSizer *orgTitleSizer = new wxBoxSizer( wxHORIZONTAL );
    wxStaticText* orgTitleText = new wxStaticText(panel, -1, _("Organization information: "));
    font = orgTitleText->GetFont();
    font.SetWeight(wxBOLD);
    orgTitleText->SetFont( font );
    
    wxBitmap orgIcon = wxBITMAP(users);
#ifdef __WXMSW__
    orgIcon.SetMask( new wxMask(orgIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif
    
    orgTitleSizer->Add( new wxStaticBitmap(panel, -1, orgIcon ),
			0,  wxALIGN_CENTER_VERTICAL | wxALL, 4);
    orgTitleSizer->Add( orgTitleText, 1,   wxALIGN_CENTER_VERTICAL | wxALIGN_LEFT | wxALL, 4);
    
    wxBoxSizer* orgSizer = new wxBoxSizer(wxVERTICAL);

    it = organizationInformations->infos.begin();
    i=0;
    while( it != organizationInformations->infos.end() && i < 2 ){
	wxString buffer;
	if( it->first.first ==  _T("organizationName") ||  it->first.first == _T("organizationalUnitName") ){
	    buffer << it->first.second << _(": ") << it->second;
	    orgSizer->Add( new wxStaticText( panel, -1, buffer ), 1, wxALIGN_LEFT | wxALL, 2);
	}
	i++;
	it++;
    }
    
    
    summarySizer->Add( orgTitleSizer , 0 , wxEXPAND  | wxALL, 2);
    summarySizer->Add( orgSizer , 0 , wxEXPAND  | wxALL, 2);
    

     /* Private Key */

    wxBoxSizer *keyTitleSizer = new wxBoxSizer( wxHORIZONTAL );
    wxStaticText* keyTitleText = new wxStaticText(panel, -1, _("Key information: "));
    font = keyTitleText->GetFont();
    font.SetWeight(wxBOLD);
    keyTitleText->SetFont( font );
    
    wxBitmap keyIcon = wxBITMAP(mykeys);

    keyIcon.SetMask( new wxMask(keyIcon, wxColour(0xC0,0xC0,0xC0)) );

    
    keyTitleSizer->Add( new wxStaticBitmap(panel, -1, keyIcon ),
			0,  wxALIGN_CENTER_VERTICAL | wxALL, 4);
    keyTitleSizer->Add( keyTitleText, 1,   wxALIGN_CENTER_VERTICAL | wxALIGN_LEFT | wxALL, 4);
    
    wxBoxSizer* keySizer = new wxBoxSizer(wxVERTICAL);

     if( privateKey->keySize != 0 ) {
 	wxString buffer;
 	buffer << _T("Key size") << _(": ") << privateKey->keySize;
 	keySizer->Add( new wxStaticText( panel, -1, buffer ), 1, wxALIGN_LEFT | wxALL, 2);
     }
     if( privateKey->algorithm != wxEmptyString ) {
	 wxString buffer;
	 buffer << _T("Cipher") << _(": ") << privateKey->prettyAlgorithm;
	 keySizer->Add( new wxStaticText( panel, -1, buffer ), 1, wxALIGN_LEFT | wxALL, 2);
     }      
     
    summarySizer->Add( keyTitleSizer , 1 ,wxEXPAND  | wxALL, 2);
    summarySizer->Add( keySizer , 1 , wxEXPAND  | wxALL, 2);

    
    /* output file*/
    wxBoxSizer *outputTitleSizer = new wxBoxSizer( wxHORIZONTAL );
    wxStaticText* outputTitleText = new wxStaticText(panel, -1, _("Certificate request output file: "));
    font = outputTitleText->GetFont();
    font.SetWeight(wxBOLD);
    outputTitleText->SetFont( font );

    wxBitmap dirIcon = wxBITMAP(folder_mini);
#ifdef __WXMSW__
    dirIcon.SetMask( new wxMask(dirIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif
    
    outputTitleSizer->Add( new wxStaticBitmap(panel, -1, dirIcon ),
			0,  wxALIGN_CENTER_VERTICAL | wxALL, 4);
    outputTitleSizer->Add( outputTitleText, 1,  wxALIGN_CENTER_VERTICAL | wxALIGN_LEFT | wxALL, 4);
    
    wxBoxSizer* outputSizer = new wxBoxSizer(wxVERTICAL);

     if( outputFile->filename != wxEmptyString ) {
 	wxString buffer;
 	buffer <<  outputFile->filename;
 	outputSizer->Add( new wxStaticText( panel, -1, buffer ), 
			  1,  wxEXPAND  | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 2);
     }
     
     summarySizer->Add( outputTitleSizer , 1 , wxEXPAND  | wxALL, 2);
     summarySizer->Add( outputSizer , 1 ,  wxEXPAND  | wxALL, 2);
     
     
    
     
     panel->SetSizer( summarySizer );
     summarySizer->Fit( panel );
    
   
}

void CertificateRequestWizard::Summary::onWizardPageChanging(wxWizardEvent& event)
{
}


/*** Process ***/
CertificateRequestWizard::Process::Process(wxWizard* parent,
					   User* u,
					   UserInformations* userInfos,
					   OrganizationInformations* organization,
					   PrivateKeyPasswordAlgorithm* key,
					   OutputFile* file)

     : wxWizardPageSimple( parent )
{
    generated = false;

    user = u;
    userInformations = userInfos;
    organizationInformations = organization;
    privateKey = key;
    outputFile = file;
}

void CertificateRequestWizard::Process::onWizardPageChanging(wxWizardEvent& event)
{
}

void CertificateRequestWizard::Process::onWizardPageChanged( wxWizardEvent& event )
{
    wxPanel* panel = new wxPanel( this );

    wxBoxSizer* mainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* progressSizer = new wxBoxSizer(wxVERTICAL);

    mainSizer->Add( new wxStaticText(panel, -1, _("Please wait a moment while your private key and your certificate request are generated: ")),
		    0, wxALIGN_LEFT | wxALL, 10);
    
    wxBitmap arrowIcon = wxBITMAP(add);
    wxBitmap okIcon = wxBITMAP(verify_ok);
#ifdef __WXMSW__
    arrowIcon.SetMask( new wxMask(arrowIcon, wxColour(0xC0,0xC0,0xC0)) );
    okIcon.SetMask( new wxMask(okIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif

    wxBoxSizer* primePSizer = new wxBoxSizer(wxHORIZONTAL);
    primePBitmap = new wxStaticBitmap(panel, -1, arrowIcon);
    primePSizer->Add( primePBitmap, 0, wxALIGN_LEFT | wxALL, 5 );
    primePBitmap->Hide();
    primeP = new wxStaticText(panel, -1, _("Generating prime number 'p'"));
    wxFont primePFont = primeP->GetFont();
    primePSizer->Add( primeP, 0, wxALIGN_LEFT | wxALL, 5 );
    progressSizer->Add( primePSizer, 0, wxALIGN_LEFT | wxALL, 10 );


    wxBoxSizer* primeQSizer = new wxBoxSizer(wxHORIZONTAL);
    primeQBitmap = new wxStaticBitmap(panel, -1, arrowIcon);
    primeQSizer->Add( primeQBitmap, 0, wxALIGN_LEFT | wxALL, 5 );
    primeQBitmap->Hide();
    primeQ = new wxStaticText(panel, -1, _("Generating prime number 'q'"));
    wxFont primeQFont = primeQ->GetFont();
    primeQSizer->Add( primeQ, 0, wxALIGN_LEFT | wxALL, 5 );
    progressSizer->Add( primeQSizer, 0, wxALIGN_LEFT | wxALL, 10 );


    wxBoxSizer* encryptingSizer = new wxBoxSizer(wxHORIZONTAL);
    encryptingBitmap = new wxStaticBitmap(panel, -1, arrowIcon);
    encryptingSizer->Add( encryptingBitmap, 0, wxALIGN_LEFT | wxALL, 5 );
    encryptingBitmap->Hide();
    encrypting = new wxStaticText(panel, -1, _("Encrypting private key"));
    wxFont encryptingFont = encrypting->GetFont();
    encryptingSizer->Add( encrypting, 0, wxALIGN_LEFT | wxALL, 5 );
    progressSizer->Add( encryptingSizer, 0, wxALIGN_LEFT | wxALL, 10 );


    wxBoxSizer* requestSizer = new wxBoxSizer(wxHORIZONTAL);
    requestBitmap = new wxStaticBitmap(panel, -1, arrowIcon);
    requestSizer->Add( requestBitmap, 0, wxALIGN_LEFT | wxALL, 5 );
    requestBitmap->Hide();
    request = new wxStaticText(panel, -1, _("Generating certificate request"));
    wxFont requestFont = request->GetFont();
    requestSizer->Add( request, 0, wxALIGN_LEFT | wxALL, 5 );
    progressSizer->Add( requestSizer, 0, wxALIGN_LEFT | wxALL, 10 );

    wxBoxSizer* doneSizer = new wxBoxSizer(wxHORIZONTAL);
    doneBitmap = new wxStaticBitmap(panel, -1, okIcon);
    doneSizer->Add( doneBitmap, 0, wxALIGN_LEFT | wxALL, 5 );
    doneBitmap->Hide();
    doneText = new wxStaticText(panel, -1, _("Done"));
    doneText->Hide();
    doneSizer->Add( doneText, 0, wxALIGN_LEFT | wxALL, 5 );
    progressSizer->Add( doneSizer, 0, wxALIGN_LEFT | wxALL, 10 );

    mainSizer->Add( progressSizer, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 20 );

    wxString buffer;
    buffer << _("The certificate request is available here: ") << outputFile->filename;
    finishText = new wxStaticText( panel, -1, buffer);
    finishText->Hide();
    mainSizer->Add( finishText, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 20 );

    panel->SetSizer( mainSizer );
    mainSizer->Fit( panel );


    primePBitmap->Show();
    primePBitmap->Refresh();

    generated = true;
}



void CertificateRequestWizard::Process::onIdle(wxIdleEvent& event)
{
    if( generated ) {
	/* Real Process */
	/** Prime p **/

	pkcs8 key;
	wxString errorMsg = wxEmptyString;

	int ret = key.generateKeyPair( privateKey->keySize, generateKeyCallback, (void*)primeQBitmap );

	switch( ret ) {
	case -1: errorMsg = _("Cannot seed the pseudo random number generator.");
	    break;
	case -2: errorMsg = _("The generated key pair is invalid and must be regenerated.");
	    break;
	case -3: errorMsg = _("An error occured while performing tests on the generated key.");
	    break;
	case -4: errorMsg = _("Cannot assign the generated key to the current PKCS#8 object.");
	    break;
	}

	if( errorMsg != wxEmptyString ) {
	    wxMessageBox( errorMsg, _("Error"), wxICON_ERROR | wxOK, this );
	    generated = false;
	    return;
	}
	
	
	/** Encrypting key **/
	encryptingBitmap->Show();
	encryptingBitmap->Refresh();
	
	wxString buffer;
	buffer << _(P12_PATH) <<  wxFileName::GetPathSeparators();
	wxFileName prefixP12( buffer );
	prefixP12=wxMyPrepend(prefixP12, std2wx(user->getHome()) );
	
	wxFileName privateKeyFilename;
	wxFile* privateKeyFile = new wxFile();
	privateKeyFilename.AssignTempFileName( prefixP12.GetFullPath(), privateKeyFile );

	if( key.save( wx2std(privateKeyFilename.GetFullPath()).c_str(), 
								getCipher(wx2std(privateKey->algorithm)),
								wx2std(privateKey->passphrase).c_str() ) != 0 ) {
	    wxString msg;
	    msg << _("Cannot write your private key on disk: ") << privateKeyFilename.GetFullPath();
	    wxMessageBox( msg, _("Error"), wxICON_ERROR | wxOK, this);
	    generated = false;
	    return;
	}


	
	/** Generate PKCS10 **/
	std::vector< std::pair< std::string, std::string > > infos;

	std::vector< std::pair< std::pair< wxString, wxString >, wxString > >::iterator it;

	for( it = userInformations->infos.begin(); it != userInformations->infos.end(); it ++ ) {
	    std::pair<std::string, std::string> entry;
	    entry.first = wx2std(it->first.first);
	    entry.second = wx2std(it->second);
	    infos.push_back( entry );
	}

	for( it = organizationInformations->infos.begin(); it != organizationInformations->infos.end(); it ++ ) {
	    std::pair<std::string, std::string> entry;
	    entry.first = wx2std(it->first.first);
	    entry.second = wx2std(it->second);
	    infos.push_back( entry );
	}

	pkcs10 request( wx2std(privateKeyFilename.GetFullPath()).c_str(), 
									wx2std(privateKey->passphrase).c_str(), 
									infos);
	if( request.write( wx2std(outputFile->filename).c_str() ) != 0 ) {
	    wxString msg;
	    msg << _("Cannot write your certificate request on disk: ") << outputFile->filename;
	    wxMessageBox( msg, _("Error"), wxICON_ERROR | wxOK, this);
	}

	/* Make a copy of the request in the P12/ directory */
	wxFileName requestFilename( privateKeyFilename );
	requestFilename.SetExt( _T("p10") );
	wxFile requestFile;
	requestFile.Create( requestFilename.GetFullPath(), TRUE, wxS_IRUSR | wxS_IWUSR );
	requestFile.Close();
	if( request.write( wx2std(requestFilename.GetFullPath()).c_str() ) != 0 ) {
	    wxString msg;
	    msg << _("Cannot write your certificate request on disk: ") << requestFilename.GetFullPath();
	    wxMessageBox( msg, _("Error"), wxICON_ERROR | wxOK, this);
	}

	requestBitmap->Show();
	requestBitmap->Refresh();

	doneText->Show();
	doneText->Refresh();
	doneBitmap->Show();
	doneBitmap->Refresh();

	finishText->Show();
	finishText->Refresh();

	generated = false;
    }
}



void CertificateRequestWizard::Process::generateKeyCallback(int p, int n, void *arg)
{
    static bool p_done = false;
    wxStaticBitmap* primeQBitmap = (wxStaticBitmap*) arg;

    if( primeQBitmap != NULL ) {
	
	if( p_done ) {
	    primeQBitmap->Show();
	    primeQBitmap->Refresh();
	}
	else {
	}
	if( p == 3 ) p_done = true;
	
    }
}



CertificateRequestWizard::CertificateRequestWizard( User* u, wxWindow* parent )
{
    user = u;
    success = false;

    wizard = new wxWizard( parent, -1, _("Certificate request wizard"),
			   wxBITMAP(wiz1) );
    
    UserInformations* userInformations = new UserInformations( wizard );
    OrganizationInformations* organizationInformations = new OrganizationInformations( wizard );
    OptionnalAttributes* optionnalAttributes = new OptionnalAttributes( wizard );
    PrivateKeyPasswordAlgorithm* privateKeyPasswordAlgorithm = new PrivateKeyPasswordAlgorithm( wizard );
    OutputFile* outputFile = new OutputFile( wizard );

    Summary* summary = new Summary( wizard,
				    userInformations,
				    organizationInformations,
				    privateKeyPasswordAlgorithm,
				    outputFile);

    Process* process = new Process( wizard,
				    user,
				    userInformations,
				    organizationInformations,
				    privateKeyPasswordAlgorithm,
				    outputFile);

    wxWizardPageSimple::Chain( userInformations, organizationInformations );
    wxWizardPageSimple::Chain( organizationInformations, optionnalAttributes );
    wxWizardPageSimple::Chain( optionnalAttributes, privateKeyPasswordAlgorithm );
    wxWizardPageSimple::Chain( privateKeyPasswordAlgorithm, outputFile );
    wxWizardPageSimple::Chain( outputFile, summary );
    wxWizardPageSimple::Chain( summary, process );

    wizard->FitToPage( userInformations );
//     wizard->SetPageSize(size);

    success = wizard->RunWizard( userInformations );
//     if( wizard->RunWizard(userInformations) )
//         wxMessageBox(_("The wizard successfully completed"), _("That's all"),
//                      wxICON_INFORMATION | wxOK);
    
}

CertificateRequestWizard::~CertificateRequestWizard()
{
    wizard->Destroy();
}

