/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _KEY_CHOICE_DLG_HH
#define _KEY_CHOICE_DLG_HH


#include <wx/wx.h>
#include <wx/dialog.h>

#include <wx/checkbox.h>
#include "CryptonitDlg.hh"
#include "../User.hh"
#include "../Certificate.hh"
#include "../KeyStore.hh"
#include "../Key.hh"
#include "../User.hh"
#include "KeyChoiceDlg.hh"


using namespace Cryptonit;

enum keyType{
    KEY_SIGN,
    KEY_DECRYPT,
    KEY_ALL
};


typedef struct StoreAndKey{
    KeyStore *ks;
    Certificate *c;
} StoreAndKey;

class KeyChoiceDlg : public wxDialog
{
public:
    
    KeyChoiceDlg(wxWindow *parent, 
		 std::vector<KeyStore *> s, 
		 User *u,
		 keyType type, 
		 const wxString& title=_("Choose your private key"));

    ~KeyChoiceDlg();
    
  void fillKeyCombo(wxCommandEvent  &WXUNUSED(event));
    Key* getKeyAndCert(Certificate &c , int *r);
    

private :
    wxBoxSizer *mainSizer;
    wxStaticBox *advancebox;
    wxStaticBoxSizer *chkboxSizer;
    wxComboBox *keyCombo;
    wxButton* certificateViewerBtn;
    wxButton *advanceBtn;
    wxCheckBox* boxAttrib1;
    wxCheckBox* boxAttrib2;
    std::vector<KeyStore *> stores;
    std::vector<KeyStore *>::iterator storeIt;
    std::vector<Certificate>::iterator certIt;
    std::vector<Certificate> listCertif;
    User *user;
    bool displayAdvance;
  

    std::vector<Certificate *> certVect;
    wxButton *okBtn;
    wxButton *cvBtn;

    void onCVBtn(wxCommandEvent  &WXUNUSED(event));
    void onADVBtn(wxCommandEvent  &WXUNUSED(event));
    void enableButtons(const bool enable);
  

    DECLARE_EVENT_TABLE()
	};

enum
    { 
      KCDLG_CV_BTN=20000,
      KCDLG_ADV_BTN,
      KCDLG_CB1_BTN,
      KCDLG_CB2_BTN
    };


#endif
