/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "encryptSelf.h"

enum {
  WRONG_ARG_COUNT = 1,
  ERROR_GETTING_PASSWORD,
} error;

int main(int argc, char **argv)
{
  char *password;
  int stub;
  int rv = 0;

  /* Do we have the right amount of arguments ? */
  if((argc != 3) && (argc != 4)) {
    printf("usage:\n\t%s infile "
	   "oufile [-win32]\n\n", argv[0]);
    rv = WRONG_ARG_COUNT;
    goto end;
  }

  if((password = getpass("Input password: ")) == NULL) {
    rv = ERROR_GETTING_PASSWORD; 
    goto end; 
  } 

  if(argc == 3) {
    stub = STUB_POSIX;
  } else {
    stub = STUB_WIN32;
  }
  rv = encrypt_self(argv[1], argv[2], password, stub);

 end:
  return rv;
}
