/*
 * PT
 * Copyright (C) 2002  The Printing Tool Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * preferences.h
 */

#ifndef PREFERENCES_H
#define PREFERENCES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <cups/cups.h>
#include <gtk/gtk.h>

#ifndef DEFINITIONS_H
#include "definitions.h"
#endif /*DEFINITIONS_H*/


/*
 * typedef
 */

typedef struct
{
	gboolean show_rank;
	gboolean show_priority;
	gboolean show_id;
	gboolean show_user;
	gboolean show_title;
	gboolean show_format;
	gboolean show_copies;
	gboolean show_dest;
	gboolean show_state;
	gboolean show_size;
	gboolean show_creation_time;
	gboolean show_processing_time;
	gboolean sort_toggle;
	gint sort_item;
	gchar* filter_dest;
	gchar* host;
	gint port;
	gint refresh_interval;
	gint priority_change;
	gint width;
	gint height;
	gchar *user;
	http_encryption_t ssl;
}
preferences_t;

/*
 * functions
 */

void p_read_preferences (preferences_t *p);
void p_write_preferences (const preferences_t *p);

#endif /*PREFERENCES_H*/
