/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mit Jul 12 22:54:51 MEST 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "inkompatibel.h"

#include <cstdlib>
#include <cstdio>
#include <ctime>

#if HAVE_GETOPT
/* Laut man-page muss man <unistd.h> includen, wenn man getopt() verwenden
   will. Laut gcc <getopt.h>. gcc sitzt am lngeren Hebel... */
//#include <unistd.h>
#include <getopt.h>
#endif

#include <qdatetime.h>
#include <qapp.h>
#include <qmessagebox.h>

#include "inkompatibel.h"
#include "cuyointl.h"
#include "fehler.h"

#include "cuyo.h"
#include "global.h"

#include "config.h"


void aufrufFehler() {

  exit(1);
}


#if !HAVE_GETOPT
/* selbstprogrammiertes getopt()... funkioniert sehr eingeschrnkt. */

int optind = 1;

char getopt(int argc, char * const argv[], const char * optstring) {
  if (optind < argc && argv[optind][0] == '-') {
    char c = argv[optind++][1];
    const char * o = optstring;
    while (*o) {
      if (c == *o++) return c;
    }
    fprintf(stderr, _("Unknown option '%c'\n"), c);
    return '?';
  } else
    return -1;
}

#endif



void scanOptionen(int argc, char *argv[]) {
  int opt_chr;

  /* Erst mal defaults setzen */
  gDebug = false;
  gDateiUebergeben = false;

  while ((opt_chr = getopt(argc, argv, "d")) != -1) {
    switch (opt_chr) {
      case 'd':
        gDebug = true;
	break;
      case '?':
        aufrufFehler();
	break;
      default:
        throw Fehler(_("Internal error during parsing of options"));
    }
  }

  /* Ist da noch ein Argument brig? Dann ist das die bergebene
     ld-Datei. */
  if (optind < argc) {
    gDateiUebergeben = true;
    gLevelDatei = argv[optind++];
  }
  
  /* Immernoch Argumente brig? Das ist ein Fehler */
  if (optind < argc) {
    fprintf(stderr, _("%s: Too many arguments\n"), argv[0]);
    aufrufFehler();
  }


}





int main(int argc, char *argv[])
{
  
  /* Lokalisierung */
  /* PACKAGE und LOCALEDIR stammen aus config.h */
  //setlocale (LC_ALL, "");
  //bindtextdomain (PACKAGE, LOCALEDIR);
  //textdomain (PACKAGE);

  /* Muss auerhalb vom try stehen, weil sonst QMessageBox
     im catch nicht mehr geht. */
  QApplication a(argc,argv);


  try {
    
    /* Der Pfaditerator braucht unser 0tes Argument, um in lokalen
       Verzeichnissen nach den Daten-Dateien zu suchen. */
    gCuyoPfad = nimmPfad(argv[0]);
    
    /* Ist das hier noch ntig, nachdem es im Moment vor jedem Level-Start
       einzeln aufgerufen wird? Egal. */
    srand(time(0));
    
    scanOptionen(argc, argv);
        
    Cuyo cuyo(0, "Cuyo-Fenster");
    a.setMainWidget(&cuyo);
    cuyo.show();
    return a.exec();

  } catch (Fehler f) {
    fprintf(stderr, _("Error: %s\n"), f.getText().data());
    QMessageBox::warning(NULL, _("Error"), f.getText());
    return 1;
  }
  
}
