/*
 * Danpei -- a GTK+ based Image Viewer
 * Copyright (C) 2001-2003 Shinji Moiino
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* image_cache.h */

#ifndef __IMAGE_CACHE_H__

#define __IMAGE_CACHE_H__

#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "typedefs.h"

/* Constant definitions  */

/* Macro definitions     */

/* Free the CacheList structure object's member. */
#define FREE_CACHELIST_MEMBER_AND_CACHE(cp) \
if (cp->cache_name != NULL) {               \
  remove(cp->cache_name);                   \
  free(cp->cache_name);                     \
}                                           \
if (cp->pixmap_name != NULL) {              \
  free(cp->pixmap_name);                    \
}

#define FREE_CACHELIST_MEMBER_ONLY(cp) \
if (cp->cache_name != NULL) {          \
  free(cp->cache_name);                \
}                                      \
if (cp->pixmap_name != NULL) {         \
  free(cp->pixmap_name);               \
}

/* Structure definitions */

/* Public functions */
void     image_cache_manage_cache_structure_init    (ManageCache*    );

void     image_cache_manage_cache_structure_destroy (ManageCache*  ,
                                                     gboolean        );

void     image_cache_add                            (ManageCache*  ,
                                                     GdkPixbuf*    ,
                                                     gint          ,
                                                     gint          ,
                                                     gchar*          );

void     image_cache_delete                         (ManageCache*  ,
                                                     gchar*          );

void     image_cache_serch                          (TopLevel*     ,
                                                     Thumbnail*    ,
                                                     gint          ,
                                                     gchar*          );

void     image_cache_rename                         (ManageCache*  ,
                                                     gchar*        ,
                                                     gchar*          );

void     image_cache_copy                           (ManageCache*  ,
                                                     gchar*        ,
                                                     gchar*          );

void     image_cache_check_using_disk               (TopLevel*       );

gboolean image_cache_write_info_to_disk             (TopLevel*       );

gboolean image_cache_read_info_from_disk            (TopLevel*       );

#endif  /* __IMAGE_CACHE_H__ */

