/*
 * Danpei -- a GTK+ based Image Viewer
 * Copyright (C) 2001-2003 Shinji Moiino
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* These codes are mostly taken from:
 * gimageview-0.1.7 Copyright (C) 2001 Takuro Ashie
 */
/* pcx.h */

#ifndef __PCX_H__

#define __PCX_H__

#include <gtk/gtk.h>

/* Constant definitions */

/* Structure definitions */
typedef struct StructPcxHeader {
  guint8 manufacturer;
  guint8 version;
  guint8 compression;
  guint8 bpp;
  gint16 x1, y1;
  gint16 x2, y2;
  gint16 hdpi;
  gint16 vdpi;
  guint8 colormap[48];
  guint8 reserved;
  guint8 planes;
  gint16 bytesperline;
  gint16 color;
  guint8 filler[58];
} PcxHeader;

typedef struct StructPcxInfo {
  gint width;
  gint height;
  gint ncolors;
} PcxInfo;

/* Public function declarations. */
guchar *pcx_load (const gchar*, gint*, gint* );

#endif /* __PCX_H__ */

