/*
 * Danpei -- a GTK+ based Image Viewer
 * Copyright (C) 2001-2003 Shinji Moiino
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* pop_menu_dirtree.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdkx.h>

#include "config.h"
#include "dialog.h"
#include "directory_menu.h"
#include "dirtree.h"
#include "edit_menu.h"
#include "intl.h"
#include "typedefs.h"
#include "version.h"

/* Static function declarations. */

/* Function definitions. */
/* 
 * @pop_menu_dirtree_cb_deactivate
 *
 *
 *
 */
void pop_menu_dirtree_cb_deactivate (GtkWidget *widget,
                                     gpointer  data   ,
                                     guint     action   ) {
  TopLevel *tp;

  /* Initialize the elocal variables. */
  tp = (TopLevel*)data;

  dirtree_set_directory_non_hilighted(tp);

  return;
}

/*
 * @pop_menu_dirtree_cb_paste
 *
 *
 *
 */
void pop_menu_dirtree_cb_paste(GtkWidget *widget,
                               gpointer  data   ,
                               guint     action   ) {
  TopLevel  *tp;
  gint      save_focus_row;

  /* Initialize the local variables. */
  tp = (TopLevel*)data;
  save_focus_row = 0;

  /* Save current focus row and set dropped row focused. */
  save_focus_row = GTK_CLIST(tp->dir_tree.ctree)->focus_row;
  GTK_CLIST(tp->dir_tree.ctree)->focus_row = tp->dnd_selected_row;

  /* Pasted. */
  edit_menu_cb_paste(NULL, data, 0);

  /* Restore the focus row. */
  GTK_CLIST(tp->dir_tree.ctree)->focus_row = save_focus_row;

  dirtree_set_directory_non_hilighted(tp);

  return;
}

/*
 * @pop_menu_dirtree_cb_new
 *
 *  Create a new directory under the directory on which the cursor is
 *  pointing.
 *
 */
void pop_menu_dirtree_cb_new(GtkWidget *widget,
                             gpointer  data   ,
                             guint     action   ) {
  TopLevel  *tp;
  gint      save_focus_row;

  /* Initialize the local variables. */
  tp = (TopLevel*)data;
  save_focus_row = 0;

  /* Save current focus row and set dropped row focused. */
  save_focus_row = GTK_CLIST(tp->dir_tree.ctree)->focus_row;
  GTK_CLIST(tp->dir_tree.ctree)->focus_row = tp->dnd_selected_row;

  /* Create a new directory. */
  directory_menu_cb_new(NULL, data, 0);

  /* Restore the focus row. */
  GTK_CLIST(tp->dir_tree.ctree)->focus_row = save_focus_row;

  dirtree_set_directory_non_hilighted(tp);

  return;
}

/*
 * @pop_menu_dirtree_cb_remove
 *
 *  Remove the directory on which the cursor is pointing.
 *
 */
void pop_menu_dirtree_cb_remove(GtkWidget *widget,
                                gpointer  data   ,
                                guint     action   ) {
  TopLevel  *tp;
  gint      save_focus_row;

  /* Initialize the local variables. */
  tp = (TopLevel*)data;
  save_focus_row = 0;

  /* Save current focus row and set dropped row focused. */
  save_focus_row = GTK_CLIST(tp->dir_tree.ctree)->focus_row;
  GTK_CLIST(tp->dir_tree.ctree)->focus_row = tp->dnd_selected_row;

  /* Remove the directory. */
  directory_menu_cb_remove(NULL, data, 0);

  /* Restore the focus row. */
  GTK_CLIST(tp->dir_tree.ctree)->focus_row = save_focus_row;

  dirtree_set_directory_non_hilighted(tp);

  return;
}

