/*
 * Danpei -- a GTK+ based Image Viewer
 * Copyright (C) 2001-2003 Shinji Moiino
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* thumbnail.h */

#ifndef __THUMBNAIL_H__

#define __THUMBNAIL_H__

#include <gtk/gtk.h>

#include "typedefs.h"

/* Constant definitions */
#define FILENAME_MAX_LENGTH  255

/* Structure definitions */

/* Public functions */
void       thumbnail_init                      (Thumbnail*       );

void       thumbnail_free_structure_list       (Thumbnail*       );

void       thumbnail_free_structure            (Thumbnail*       );

void       thumbnail_change_link               (ThumbnailTable*,
                                                Thumbnail*       );

void       thumbnail_create                    (Thumbnail*     ,
                                                TopLevel*        );

void       thumbnail_create_pixmap             (Thumbnail*     ,
                                                TopLevel*        );

void       thumbnail_create_icon_area          (Thumbnail*     , 
                                                TopLevel*        );

void       thumbnail_set_sensitive             (Thumbnail*     ,
                                                gboolean         );

void       thumbnail_entry_set_sensitive       (Thumbnail*     ,
                                                gboolean         );

void       thumbnail_count_selected_thumbnails (TopLevel*      ,
                                                gint             );

void       thumbnail_set_shadow                (Thumbnail*     ,
                                                gboolean         );

Thumbnail* thumbnail_get_from_path             (TopLevel*      ,
                                                gchar*           );

#endif  /* __THUMBNAIL_H__ */

