
/* darkstat: a network traffic analyzer
 * (c) 2001-2003, Emil Mikulic.
 */

#ifndef __DB_H
#define __DB_H

/* Database header */
#include "darkstat.h"
#include <stdlib.h>
#include <assert.h>



typedef struct {
	dword size_pool;
	dword used;
	void **records;
} db;

#define POOL_GROW 128

/* Initialize a db, allocate default-size pool */
void db_init(db *d);

/* Grow the pool of a db
 * Returns: 0 on failure, 1 on success
 */
inline int db_growpool(db *d);

/* Free a database. WARNING: make sure you've freed all the records first */
void db_free(db *d);

/* Grab the n-th item of a database. Returns NULL if invalid request */
inline void *db_get(const db d, const dword n);

/* Add an item to the database. Returns 0 on fail, 1 on success */
inline int db_add(db *d, void *data);

#endif

