/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.PrintStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.SAXException;

public class StandardErrorListener
implements ErrorListener {
    private int recoveryPolicy = 1;
    private int warningCount = 0;
    private PrintStream errorOutput = System.err;

    public void setErrorOutput(PrintStream printStream) {
        this.errorOutput = printStream;
    }

    public PrintStream getErrorOutput() {
        return this.errorOutput;
    }

    public void setRecoveryPolicy(int n) {
        this.recoveryPolicy = n;
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        if (this.recoveryPolicy == 0) {
            return;
        }
        String string = "";
        if (transformerException.getLocator() != null) {
            string = StandardErrorListener.getLocationMessage(transformerException) + "\n  ";
        }
        string = string + StandardErrorListener.wordWrap(StandardErrorListener.getExpandedMessage(transformerException));
        if (this.recoveryPolicy == 1) {
            this.errorOutput.println("Warning: " + string);
            ++this.warningCount;
            if (this.warningCount > 25) {
                System.err.println("No more warnings will be displayed");
                this.recoveryPolicy = 0;
                this.warningCount = 0;
            }
        } else {
            this.errorOutput.println("Recoverable error");
            this.errorOutput.println(string);
            this.errorOutput.println("Processing terminated because error recovery is disabled");
            throw new TransformerException(transformerException);
        }
    }

    public void error(TransformerException transformerException) throws TransformerException {
        String string = (transformerException instanceof ValidationException ? "Validation error " : "Error ") + StandardErrorListener.getLocationMessage(transformerException) + "\n  " + StandardErrorListener.wordWrap(StandardErrorListener.getExpandedMessage(transformerException));
        this.errorOutput.println(string);
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        this.error(transformerException);
        throw transformerException;
    }

    public static String getLocationMessage(TransformerException transformerException) {
        SourceLocator sourceLocator = transformerException.getLocator();
        if (sourceLocator == null) {
            if (transformerException.getException() instanceof TransformerException) {
                return StandardErrorListener.getLocationMessage((TransformerException)transformerException.getException());
            }
            if (transformerException.getCause() instanceof TransformerException) {
                return StandardErrorListener.getLocationMessage((TransformerException)transformerException.getCause());
            }
            return "";
        }
        String string = "";
        if (sourceLocator instanceof DOMLocator) {
            string = string + "at " + ((DOMLocator)sourceLocator).getOriginatingNode().getNodeName() + " ";
        } else if (sourceLocator instanceof Instruction) {
            string = string + "at " + ((Instruction)sourceLocator).getInstructionName() + " ";
        }
        string = string + "on line " + sourceLocator.getLineNumber() + " ";
        if (sourceLocator.getColumnNumber() != -1) {
            string = string + "column " + sourceLocator.getColumnNumber() + " ";
        }
        if (sourceLocator.getSystemId() != null) {
            string = string + "of " + sourceLocator.getSystemId() + ":";
        }
        return string;
    }

    public static String getExpandedMessage(TransformerException transformerException) {
        String string = "";
        Throwable throwable = transformerException;
        while (throwable != null) {
            String string2 = throwable.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            if (!string2.equals("TRaX Transform Exception") && !string.endsWith(string2)) {
                if (!string.equals("")) {
                    string = string + ": ";
                }
                string = string + throwable.getMessage();
            }
            if (throwable instanceof TransformerException) {
                throwable = ((TransformerException)throwable).getException();
                continue;
            }
            if (!(throwable instanceof SAXException)) break;
            throwable = ((SAXException)throwable).getException();
        }
        return string;
    }

    private static String wordWrap(String string) {
        int n = string.indexOf(10);
        if (n < 0) {
            n = string.length();
        }
        if (n > 100) {
            int n2 = 90;
            while (string.charAt(n2) != ' ' && n2 > 0) {
                --n2;
            }
            if (n2 > 10) {
                return string.substring(0, n2) + "\n  " + StandardErrorListener.wordWrap(string.substring(n2 + 1));
            }
            return string;
        }
        return string;
    }
}

