/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.CallableFunction;
import net.sf.saxon.instruct.FunctionSignature;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class UserFunctionCall
extends FunctionCall {
    private SequenceType staticType;
    private CallableFunction function;
    private int fingerprint;
    private boolean tailRecursive = false;

    public void setFingerprint(int n) {
        this.fingerprint = n;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public void setStaticType(SequenceType sequenceType) {
        this.staticType = sequenceType;
    }

    public void setFunction(FunctionSignature functionSignature, CallableFunction callableFunction) throws XPathException {
        this.function = callableFunction;
        int n = functionSignature.getNumberOfArguments();
        this.checkArgumentCount(n, n);
        SequenceType[] sequenceTypeArray = functionSignature.getArgumentTypes();
        int n2 = 0;
        while (n2 < n) {
            RoleLocator roleLocator = new RoleLocator(0, this.getName(), n2);
            this.argument[n2] = TypeChecker.staticTypeCheck(this.argument[n2], sequenceTypeArray[n2], false, roleLocator);
            ++n2;
        }
    }

    public String getName() {
        if (this.function == null) {
            return "*** call to user function ***";
        }
        return this.function.getFunctionName();
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public ItemType getItemType() {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            return 1792;
        }
        return this.staticType.getCardinality();
    }

    public Expression simplify() throws XPathException {
        int n = 0;
        while (n < this.getNumberOfArguments()) {
            this.argument[n] = this.argument[n].simplify();
            ++n;
        }
        return this;
    }

    public boolean markTailFunctionCalls() {
        this.tailRecursive = true;
        return true;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Value value = this.callFunction(xPathContext);
        if (value instanceof Item) {
            return (Item)((Object)value);
        }
        return value.iterate(xPathContext).next();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return this.callFunction(xPathContext).iterate(xPathContext);
    }

    private Value callFunction(XPathContext xPathContext) throws XPathException {
        int n = this.getNumberOfArguments();
        Value[] valueArray = new Value[n];
        int n2 = 0;
        while (n2 < n) {
            valueArray[n2] = ExpressionTool.lazyEvaluate(this.argument[n2], xPathContext);
            ++n2;
        }
        if (this.tailRecursive) {
            return new ObjectValue(new FunctionCallPackage(this.function, valueArray, xPathContext));
        }
        Controller controller = xPathContext.getController();
        Object[] objectArray = controller.saveContext();
        controller.setGlobalContext();
        controller.setCurrentIterator(null);
        try {
            Value value = this.function.call(valueArray, controller, true);
            controller.restoreContext(objectArray);
            return value;
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof XPathException) {
                throw (XPathException)transformerException;
            }
            Throwable throwable = transformerException.getException();
            if (throwable instanceof XPathException) {
                throw (XPathException)throwable;
            }
            throw new XPathException.Dynamic(transformerException);
        }
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "function " + this.getName() + (this.tailRecursive ? " (tail call)" : ""));
        int n2 = 0;
        while (n2 < this.getNumberOfArguments()) {
            this.argument[n2].display(n + 1, namePool);
            ++n2;
        }
    }

    public static class FunctionCallPackage {
        private CallableFunction function;
        private Value[] actualArgs;
        private XPathContext evaluationContext;

        public FunctionCallPackage(CallableFunction callableFunction, Value[] valueArray, XPathContext xPathContext) {
            this.function = callableFunction;
            this.actualArgs = valueArray;
            this.evaluationContext = xPathContext;
        }

        public Value call() throws XPathException {
            Controller controller = this.evaluationContext.getController();
            Object[] objectArray = controller.saveContext();
            controller.setGlobalContext();
            controller.setCurrentIterator(null);
            try {
                Value value = this.function.call(this.actualArgs, controller, false);
                controller.restoreContext(objectArray);
                return value;
            }
            catch (TransformerException transformerException) {
                if (transformerException instanceof XPathException) {
                    throw (XPathException)transformerException;
                }
                Throwable throwable = transformerException.getException();
                if (throwable instanceof XPathException) {
                    throw (XPathException)throwable;
                }
                throw new XPathException.Dynamic(transformerException);
            }
        }
    }
}

