/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class Unicode
extends SystemFunction {
    public static final int TO_CODEPOINTS = 0;
    public static final int FROM_CODEPOINTS = 1;

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        switch (this.operation) {
            case 0: {
                throw new UnsupportedOperationException("Cannot call evaluateItem on a sequence");
            }
            case 1: {
                return new StringValue(Unicode.unicodeToString(this.argument[0].iterate(xPathContext)));
            }
        }
        throw new UnsupportedOperationException("Unknown Unicode operation");
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        switch (this.operation) {
            case 0: {
                return Unicode.stringToUnicode(this.argument[0].evaluateItem(xPathContext).getStringValue());
            }
            case 1: {
                return SingletonIterator.makeIterator(this.evaluateItem(xPathContext));
            }
        }
        throw new UnsupportedOperationException("Unknown Unicode operation");
    }

    private static SequenceIterator stringToUnicode(String string) {
        return new StringValue(string).iterateCharacters();
    }

    private static CharSequence unicodeToString(SequenceIterator sequenceIterator) throws XPathException {
        StringBuffer stringBuffer = new StringBuffer();
        NumericValue numericValue;
        while ((numericValue = (NumericValue)sequenceIterator.next()) != null) {
            long l = numericValue.asLong();
            if (l > Integer.MAX_VALUE || !XMLChar.isValid((int)l)) {
                throw new XPathException.Dynamic("Invalid XML character [decimal " + l + "]");
            }
            if (l < 65536L) {
                stringBuffer.append((char)l);
                continue;
            }
            stringBuffer.append(XMLChar.highSurrogate((int)l));
            stringBuffer.append(XMLChar.lowSurrogate((int)l));
        }
        return stringBuffer;
    }
}

