/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Block;

public class AttributeSet {
    private AttributeSet[] useAttributeSets;
    private Block body;
    private boolean needsStackFrame;

    public void initialize(AttributeSet[] attributeSetArray, Block block, boolean bl) {
        this.useAttributeSets = attributeSetArray;
        this.body = block;
        this.needsStackFrame = bl;
    }

    public void expand(Controller controller) throws TransformerException {
        if (this.useAttributeSets != null) {
            AttributeSet.expand(this.useAttributeSets, controller);
        }
        if (this.needsStackFrame) {
            Bindery bindery = controller.getBindery();
            bindery.openStackFrame(ParameterSet.EMPTY_PARAMETER_SET, null);
            this.body.processLeavingTail(controller.newXPathContext());
            bindery.closeStackFrame();
        } else {
            this.body.processLeavingTail(controller.newXPathContext());
        }
    }

    protected static void expand(AttributeSet[] attributeSetArray, Controller controller) throws TransformerException {
        int n = 0;
        while (n < attributeSetArray.length) {
            attributeSetArray[n].expand(controller);
            ++n;
        }
    }
}

