/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class ProcessingInstruction
extends SimpleNodeConstructor {
    private Expression name;

    public ProcessingInstruction(Expression expression) {
        this.name = expression;
    }

    public String getInstructionName() {
        return "processing-instruction";
    }

    public ItemType getItemType() {
        return NodeKindTest.PROCESSING_INSTRUCTION;
    }

    public int getCardinality() {
        return 512;
    }

    public void typeCheck(StaticContext staticContext) throws XPathException {
        this.name = this.name.analyze(staticContext);
        RoleLocator roleLocator = new RoleLocator(4, "processing-instruction:name", 0);
        this.name = TypeChecker.staticTypeCheck(this.name, SequenceType.SINGLE_STRING, false, roleLocator);
    }

    public int getDependencies() {
        return this.name.getDependencies() | super.getDependencies();
    }

    public void getXPathExpressions(List list) {
        list.add(this.name);
        super.getXPathExpressions(list);
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.name = this.name.promote(promotionOffer);
        super.promoteInst(promotionOffer);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        String string = this.name.evaluateAsString(xPathContext);
        if (!XMLChar.isValidNCName(string) || string.equalsIgnoreCase("xml")) {
            Instruction.recoverableError(this, "Processing instruction name is invalid: " + string, controller);
            return null;
        }
        String string2 = this.expandChildren(xPathContext).toString();
        int n = string2.indexOf("?>");
        if (n >= 0) {
            Instruction.recoverableError(this, "Invalid characters (?>) in processing instruction", controller);
            string2 = string2.substring(0, n + 1) + " " + string2.substring(n + 1);
        }
        controller.getReceiver().processingInstruction(string, string2, 0);
        return null;
    }

    protected int evaluateNameCode(XPathContext xPathContext) throws XPathException {
        String string = this.name.evaluateAsString(xPathContext);
        if (!XMLChar.isValidNCName(string) || string.equalsIgnoreCase("xml")) {
            throw new XPathException.Dynamic("Processing instruction name is invalid: " + string);
        }
        return xPathContext.getController().getNamePool().allocate("", "", string);
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "processing-instruction");
        this.name.display(n + 1, namePool);
        super.display(n + 1, namePool);
    }
}

