/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.SequenceChecker;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instr;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class SequenceInstruction
extends ExprInstruction {
    private Expression select;
    private SequenceType requiredType;
    private boolean closeTextNode = false;

    public SequenceInstruction(Expression expression, SequenceType sequenceType) {
        this.select = expression;
        this.requiredType = sequenceType;
    }

    public void setCloseTextNode(boolean bl) {
        this.closeTextNode = bl;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public Expression simplify() throws XPathException {
        if (this.select != null) {
            this.select = this.select.simplify();
        }
        return super.simplify();
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        if (this.select != null) {
            this.select = this.select.analyze(staticContext);
            if (this.requiredType != null) {
                RoleLocator roleLocator = new RoleLocator(4, "sequence/select", 0);
                this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, roleLocator);
            }
        }
        return super.analyze(staticContext);
    }

    public void getXPathExpressions(List list) {
        if (this.select != null) {
            list.add(this.select);
            return;
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (!(this.children[n] instanceof Expression)) {
                    throw new IllegalStateException("Children of an ExprInstruction must be Expressions");
                }
                list.add(this.children[n]);
                ++n;
            }
        }
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.select != null) {
            this.select = this.select.promote(promotionOffer);
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n] instanceof Expression) {
                    Expression expression = ((Expression)((Object)this.children[n])).promote(promotionOffer);
                    this.children[n] = expression instanceof Instr ? (Instr)((Object)expression) : new SequenceInstruction(expression, null);
                } else {
                    throw new IllegalStateException("Children of an ExprInstruction must be Expressions");
                }
                ++n;
            }
        }
    }

    public String getInstructionName() {
        return "sequence";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        SequenceReceiver sequenceReceiver = xPathContext.getController().getReceiver();
        if (this.select != null) {
            Item item;
            SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
            while ((item = sequenceIterator.next()) != null) {
                SequenceInstruction.appendItem(item, xPathContext, sequenceReceiver);
            }
            if (this.closeTextNode) {
                sequenceReceiver.characters("", 0);
            }
            return null;
        }
        if (this.requiredType == null) {
            TailCall tailCall = null;
            if (this.children != null) {
                tailCall = this.processChildrenLeavingTail(xPathContext);
            }
            return tailCall;
        }
        SequenceChecker sequenceChecker = new SequenceChecker();
        sequenceChecker.setRequiredType(this.requiredType);
        sequenceChecker.setUnderlyingReceiver(sequenceReceiver);
        xPathContext.getController().setReceiver(sequenceChecker);
        if (this.select != null) {
            Item item;
            SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
            while ((item = sequenceIterator.next()) != null) {
                SequenceInstruction.appendItem(item, xPathContext, sequenceChecker);
            }
            if (this.closeTextNode) {
                sequenceReceiver.characters("", 0);
            }
        }
        if (this.children != null) {
            this.processChildren(xPathContext);
        }
        sequenceChecker.finalCheck();
        xPathContext.getController().setReceiver(sequenceReceiver);
        return null;
    }

    public static void appendItem(Item item, XPathContext xPathContext, SequenceReceiver sequenceReceiver) throws TransformerException {
        block0: while (item instanceof ObjectValue && ((ObjectValue)item).getObject() instanceof UserFunctionCall.FunctionCallPackage) {
            Value value = ((UserFunctionCall.FunctionCallPackage)((ObjectValue)item).getObject()).call();
            SequenceIterator sequenceIterator = value.iterate(xPathContext);
            Item item2;
            while ((item2 = sequenceIterator.next()) != null) {
                if (item2 instanceof ObjectValue && ((ObjectValue)item).getObject() instanceof UserFunctionCall.FunctionCallPackage) {
                    item = item2;
                    continue block0;
                }
                sequenceReceiver.append(item2);
            }
            return;
        }
        sequenceReceiver.append(item);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (this.children != null) {
            throw new IllegalStateException("Cannot process xsl:sequence with children as an expression");
        }
        return this.select.iterate(xPathContext);
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "sequence");
        if (this.select != null) {
            this.select.display(n + 1, namePool);
        }
        if (this.children != null) {
            Instruction.displayChildren(this.children, n + 1, namePool);
        }
    }
}

