/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.xpath.XPathException;

public final class LocationPathPattern
extends Pattern {
    public Pattern parentPattern = null;
    public Pattern ancestorPattern = null;
    public NodeTest nodeTest = AnyNodeTest.getInstance();
    protected Expression[] filters = null;
    protected int numberOfFilters = 0;
    protected Expression equivalentExpr = null;
    protected boolean firstElementPattern = false;
    protected boolean lastElementPattern = false;
    protected boolean specialFilter = false;
    private boolean usesCurrent = false;

    public void addFilter(Expression expression) {
        if (this.filters == null) {
            this.filters = new Expression[3];
        } else if (this.numberOfFilters == this.filters.length) {
            Expression[] expressionArray = new Expression[this.numberOfFilters * 2];
            System.arraycopy(this.filters, 0, expressionArray, 0, this.numberOfFilters);
            this.filters = expressionArray;
        }
        this.filters[this.numberOfFilters++] = expression;
    }

    public Pattern simplify() throws XPathException {
        if (this.parentPattern == null && this.ancestorPattern == null && this.filters == null) {
            this.nodeTest.setSystemId(this.getSystemId());
            this.nodeTest.setLineNumber(this.getLineNumber());
            return this.nodeTest;
        }
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.simplify();
            if (this.parentPattern instanceof LocationPathPattern) {
                this.usesCurrent = ((LocationPathPattern)this.parentPattern).usesCurrent;
            }
        } else if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.simplify();
            if (this.ancestorPattern instanceof LocationPathPattern) {
                this.usesCurrent = ((LocationPathPattern)this.ancestorPattern).usesCurrent;
            }
        }
        if (this.filters != null) {
            int n = this.numberOfFilters - 1;
            while (n >= 0) {
                Expression expression;
                this.filters[n] = expression = this.filters[n].simplify();
                if ((expression.getDependencies() & 1) != 0) {
                    this.usesCurrent = true;
                }
                --n;
            }
        }
        return this;
    }

    public Pattern typeCheck(StaticContext staticContext) throws XPathException {
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.typeCheck(staticContext);
        } else if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.typeCheck(staticContext);
        }
        if (this.filters != null) {
            int n = this.numberOfFilters - 1;
            while (n >= 0) {
                Expression expression;
                this.filters[n] = expression = this.filters[n].analyze(staticContext);
                if (expression instanceof BooleanValue && ((BooleanValue)expression).getValue() && n == this.numberOfFilters - 1) {
                    --this.numberOfFilters;
                }
                ((ExpressionContext)staticContext).getStyleElement().allocateSlots(expression);
                --n;
            }
        }
        if (this.nodeTest.getNodeKind() == 1 && this.numberOfFilters == 1 && (this.filters[0] instanceof IntegerValue && ((IntegerValue)this.filters[0]).getValue() == 1L || this.filters[0] instanceof PositionRange && ((PositionRange)this.filters[0]).getMinPosition() == 1 && ((PositionRange)this.filters[0]).getMaxPosition() == 1)) {
            this.firstElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.nodeTest.getNodeKind() == 1 && this.numberOfFilters == 1 && this.filters[0] instanceof IsLastExpression && ((IsLastExpression)this.filters[0]).getCondition()) {
            this.lastElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.isPositional()) {
            this.equivalentExpr = this.makeEquivalentExpression();
            this.equivalentExpr.analyze(staticContext);
            this.specialFilter = true;
        }
        return this;
    }

    private ComputedExpression makeEquivalentExpression() throws XPathException {
        byte by = this.nodeTest.getNodeKind() == 2 ? (byte)2 : 3;
        ComputedExpression computedExpression = new AxisExpression(by, this.nodeTest);
        int n = 0;
        while (n < this.numberOfFilters) {
            computedExpression = new FilterExpression(computedExpression, this.filters[n]);
            ++n;
        }
        return new PathExpression(new ParentNodeExpression(), computedExpression);
    }

    public boolean matchesX(NodeInfo nodeInfo, Controller controller) throws XPathException {
        System.err.println("Matching node " + nodeInfo + " against LP pattern " + this);
        System.err.println("Node types " + nodeInfo.getNodeKind() + " / " + this.getNodeKind());
        boolean bl = this.matches(nodeInfo, controller);
        System.err.println(bl ? "matches" : "no match");
        return bl;
    }

    public boolean matches(NodeInfo nodeInfo, Controller controller) throws XPathException {
        if (this.usesCurrent) {
            SequenceIterator sequenceIterator = controller.getCurrentIterator();
            controller.setCurrentIterator(SingletonIterator.makeIterator(nodeInfo));
            boolean bl = this.internalMatches(nodeInfo, controller);
            controller.setCurrentIterator(sequenceIterator);
            return bl;
        }
        return this.internalMatches(nodeInfo, controller);
    }

    protected boolean internalMatches(NodeInfo nodeInfo, Controller controller) throws XPathException {
        Object object;
        if (!this.nodeTest.matches(nodeInfo.getNodeKind(), nodeInfo.getFingerprint(), nodeInfo.getTypeAnnotation())) {
            return false;
        }
        if (this.parentPattern != null) {
            object = nodeInfo.getParent();
            if (object == null) {
                return false;
            }
            if (!this.parentPattern.internalMatches((NodeInfo)object, controller)) {
                return false;
            }
        }
        if (this.ancestorPattern != null) {
            object = nodeInfo.getParent();
            while (true) {
                if (object == null) {
                    return false;
                }
                if (this.ancestorPattern.internalMatches((NodeInfo)object, controller)) break;
                object = object.getParent();
            }
        }
        if (this.specialFilter) {
            if (this.firstElementPattern) {
                object = nodeInfo.iterateAxis((byte)11, this.nodeTest);
                return object.next() == null;
            }
            if (this.lastElementPattern) {
                object = nodeInfo.iterateAxis((byte)7, this.nodeTest);
                return object.next() == null;
            }
            if (this.equivalentExpr != null) {
                NodeInfo nodeInfo2;
                object = controller.newXPathContext();
                ((XPathContext)object).setCurrentIterator(SingletonIterator.makeIterator(nodeInfo));
                SequenceIterator sequenceIterator = this.equivalentExpr.iterate((XPathContext)object);
                do {
                    if ((nodeInfo2 = (NodeInfo)sequenceIterator.next()) != null) continue;
                    return false;
                } while (!nodeInfo2.isSameNode(nodeInfo));
                return true;
            }
        }
        if (this.filters != null) {
            object = controller.newXPathContext();
            ((XPathContext)object).setCurrentIterator(SingletonIterator.makeIterator(nodeInfo));
            int n = 0;
            while (n < this.numberOfFilters) {
                try {
                    if (!this.filters[n].effectiveBooleanValue((XPathContext)object)) {
                        return false;
                    }
                }
                catch (XPathException xPathException) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public int getNodeKind() {
        return this.nodeTest.getNodeKind();
    }

    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    public NodeTest getNodeTest() {
        return this.nodeTest;
    }

    private boolean isPositional() {
        if (this.filters == null) {
            return false;
        }
        int n = 0;
        while (n < this.numberOfFilters) {
            int n2 = this.filters[n].getItemType().getPrimitiveType();
            if (n2 == 517 || n2 == 515 || n2 == 532 || n2 == 516 || n2 == 643) {
                return true;
            }
            if ((this.filters[n].getDependencies() & 0xC) != 0) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

