/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public class GroupStartingIterator
implements GroupIterator {
    private SequenceIterator population;
    private Pattern startPattern;
    private Controller controller;
    private List currentMembers;
    private Item next;
    private Item current = null;
    private int position = 0;

    public GroupStartingIterator(SequenceIterator sequenceIterator, Pattern pattern, Controller controller) throws XPathException {
        this.population = sequenceIterator;
        this.startPattern = pattern;
        this.controller = controller;
        this.next = sequenceIterator.next();
    }

    private void advance() throws XPathException {
        NodeInfo nodeInfo;
        this.currentMembers = new ArrayList();
        this.currentMembers.add(this.current);
        while ((nodeInfo = (NodeInfo)this.population.next()) != null) {
            if (this.startPattern.matches(nodeInfo, this.controller)) {
                this.next = nodeInfo;
                return;
            }
            this.currentMembers.add(nodeInfo);
        }
        this.next = null;
    }

    public AtomicValue getCurrentGroupingKey() {
        return null;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator(this.currentMembers);
    }

    public Item next() throws XPathException {
        if (this.next != null) {
            this.current = this.next;
            ++this.position;
            this.advance();
            return this.current;
        }
        return null;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new GroupStartingIterator(this.population, this.startPattern, this.controller);
    }
}

