/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.SchemaType;

public final class XSLCopyOf
extends StyleElement {
    private Expression select;
    private boolean copyNamespaces;
    private int validation = 3;
    private SchemaType schemaType;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n;
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        while (n2 < attributeCollection.getLength()) {
            n = attributeCollection.getNameCode(n2);
            String string5 = this.getNamePool().getClarkName(n);
            if (string5 == "select") {
                string = attributeCollection.getValue(n2);
            } else if (string5 == "copy-namespaces") {
                string2 = attributeCollection.getValue(n2).trim();
            } else if (string5 == "validation") {
                string3 = attributeCollection.getValue(n2).trim();
            } else if (string5 == "type") {
                string4 = attributeCollection.getValue(n2).trim();
            } else {
                this.checkUnknownAttribute(n);
            }
            ++n2;
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        } else {
            this.reportAbsence("select");
        }
        if (string2 == null) {
            this.copyNamespaces = true;
        } else if (string2.equals("yes")) {
            this.copyNamespaces = true;
        } else if (string2.equals("no")) {
            this.copyNamespaces = false;
        } else {
            this.compileError("Value of copy-namespaces must be 'yes' or 'no'");
        }
        if (string3 != null) {
            n = Validation.getCode(string3);
            if (n != 4 && !this.getConfiguration().isSchemaAware()) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed");
            }
            if (n == -1) {
                this.compileError("invalid value of validation attribute");
            }
        }
        if (string4 != null) {
            this.schemaType = this.getSchemaType(string4);
            if (!this.getConfiguration().isSchemaAware()) {
                this.compileError("The type attribute is available only with a schema-aware XSLT processor");
            }
        }
        if (string4 != null && string3 != null) {
            this.compileError("The validation and type attributes are mutually exclusive");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.checkEmpty();
        this.select = this.typeCheck("select", this.select);
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        return new CopyOf(this.select, this.copyNamespaces, this.validation, this.schemaType);
    }
}

