/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.SchemaType;

public class XSLDocument
extends StyleElement {
    private int validationAction = 4;
    private SchemaType schemaType = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string3 = this.getNamePool().getClarkName(n2);
            if (string3 == "validation") {
                string = attributeCollection.getValue(n).trim();
            } else if (string3 == "type") {
                string2 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.validationAction = this.getContainingStyleSheet().getDefaultValidation();
        } else {
            this.validationAction = Validation.getCode(string);
            if (this.validationAction != 4 && !this.getConfiguration().isSchemaAware()) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed");
            }
            if (this.validationAction == -1) {
                this.compileError("Invalid value of validation attribute");
            }
        }
        if (string2 != null) {
            if (!this.getConfiguration().isSchemaAware()) {
                this.compileError("The type attribute is available only with a schema-aware XSLT processor");
            }
            this.schemaType = this.getSchemaType(string2);
        }
        if (string2 != null && string != null) {
            this.compileError("validation and type attributes are mutually exclusive");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        DocumentInstr documentInstr = new DocumentInstr(false, null, this.getBaseURI());
        documentInstr.setValidationAction(this.validationAction);
        documentInstr.setSchemaType(this.schemaType);
        this.compileChildren(executable, documentInstr);
        return documentInstr;
    }
}

