/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.style.Procedure;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public abstract class XSLVariableDeclaration
extends XSLGeneralVariable
implements VariableDeclaration {
    private int slotNumber;
    List references = new ArrayList();

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public abstract SequenceType getRequiredType();

    public void registerReference(BindingReference bindingReference) {
        this.references.add(bindingReference);
    }

    public boolean isInstruction() {
        return true;
    }

    public void fixupReferences() throws TransformerConfigurationException {
        SequenceType sequenceType = this.getRequiredType();
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            Value value = null;
            int n = 0;
            if (this instanceof XSLVariable && !this.isAssignable()) {
                if (this.select instanceof Value) {
                    value = (Value)this.select;
                }
                if (this.select != null) {
                    n = this.select.getSpecialProperties();
                }
            }
            ((BindingReference)iterator.next()).setStaticType(sequenceType, value, n);
        }
        super.fixupReferences();
    }

    public void validate() throws TransformerConfigurationException {
        super.validate();
        if (this.global) {
            if (!this.redundant) {
                this.slotNumber = this.getPrincipalStyleSheet().allocateSlotNumber();
            }
        } else {
            this.checkWithinTemplate();
            Procedure procedure = this.getOwningProcedure();
            if (procedure == null) {
                this.compileError("Local variable must be declared within a template or function");
            } else {
                this.slotNumber = procedure.allocateSlotNumber();
            }
        }
    }

    protected void fixupBinding(Binding binding) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            ((BindingReference)iterator.next()).fixup(binding);
        }
    }
}

