/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.Iterator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Err;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.Facet;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaMarker;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DerivedAtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class AtomicType
extends SimpleType
implements ItemType {
    private boolean builtIn = false;

    public void setIsBuiltIn(boolean bl) {
        this.builtIn = bl;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public boolean validate(SchemaMarker schemaMarker) throws TransformerException {
        if (!super.validate(schemaMarker)) {
            return false;
        }
        int n = this.getPrimitiveType();
        String[] stringArray = new String[]{};
        switch (n) {
            case 513: 
            case 527: 
            case 528: 
            case 529: 
            case 530: 
            case 531: {
                String[] stringArray2 = new String[]{"length", "minLength", "maxLength", "pattern", "enumeration", "whiteSpace"};
                stringArray = stringArray2;
                break;
            }
            case 514: {
                String[] stringArray3 = new String[]{"pattern", "whiteSpace"};
                stringArray = stringArray3;
                break;
            }
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: {
                String[] stringArray4 = new String[]{"pattern", "enumeration", "whiteSpace", "minInclusive", "maxInclusive", "minExclusive", "maxExclusive"};
                stringArray = stringArray4;
                break;
            }
            case 515: 
            case 532: {
                String[] stringArray5 = new String[]{"totalDigits", "fractionDigits", "pattern", "enumeration", "whiteSpace", "minInclusive", "maxInclusive", "minExclusive", "maxExclusive"};
                stringArray = stringArray5;
            }
        }
        Iterator iterator = this.getFacets();
        while (iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            boolean bl = false;
            String string = facet.getName();
            if (string.equals("enumerationSet")) {
                string = "enumeration";
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (string.equals(stringArray[n2])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) continue;
            schemaMarker.error("The " + facet.getName() + " facet is not applicable to types derived from " + this.getNamePool().getDisplayName(n), this);
            return false;
        }
        return true;
    }

    public boolean matchesItem(Item item) {
        if (item instanceof AtomicValue) {
            AtomicValue atomicValue = (AtomicValue)item;
            AtomicType atomicType = (AtomicType)atomicValue.getItemType();
            if (atomicType.getFingerprint() == this.getFingerprint()) {
                return true;
            }
            return Type.isSubType(atomicType, this);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateContent(CharSequence charSequence, NamespaceResolver namespaceResolver) throws ValidationException {
        int n = this.getFingerprint();
        if (n == 513 || n == 593 || n == 642) {
            return;
        }
        if (this.isNamespaceSensitive()) {
            if (namespaceResolver == null) {
                throw new UnsupportedOperationException("Cannot validate a QName without a namespace resolver");
            }
            try {
                String[] stringArray = Name.getQNameParts(charSequence.toString());
                String string = namespaceResolver.getURIForPrefix(stringArray[0], true);
                if (string == null) {
                    throw new ValidationException("Namespace prefix " + Err.wrap(stringArray[0]) + " has not been declared");
                }
                QNameValue qNameValue = new QNameValue(string, stringArray[1]);
                if (this.isBuiltIn()) return;
                String string2 = charSequence.toString();
                DerivedAtomicValue.makeValue(qNameValue, string2, this, true);
                return;
            }
            catch (QNameException qNameException) {
                throw new ValidationException("Invalid lexical QName " + Err.wrap(charSequence));
            }
            catch (XPathException xPathException) {
                throw new ValidationException(xPathException.getMessage());
            }
        }
        try {
            new StringValue(charSequence).convert(this);
            return;
        }
        catch (XPathException xPathException) {
            throw new ValidationException(xPathException.getMessage());
        }
    }

    public SequenceIterator getTypedValue(CharSequence charSequence, NodeInfo nodeInfo) throws ValidationException {
        if (this.isNamespaceSensitive()) {
            try {
                NodeInfo nodeInfo2;
                String[] stringArray = Name.getQNameParts(charSequence.toString());
                String string = null;
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)8);
                do {
                    if ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) continue;
                    throw new ValidationException("No namespace binding for prefix in QName value " + Err.wrap(charSequence));
                } while (!nodeInfo2.getLocalPart().equals(stringArray[0]));
                string = nodeInfo2.getStringValue();
                QNameValue qNameValue = new QNameValue(string, stringArray[1]);
                return SingletonIterator.makeIterator(qNameValue);
            }
            catch (QNameException qNameException) {
                throw new ValidationException("Malformed QName in content: " + Err.wrap(charSequence));
            }
            catch (XPathException xPathException) {
                throw new ValidationException("Malformed QName in content: " + Err.wrap(charSequence));
            }
        }
        try {
            return SingletonIterator.makeIterator(new StringValue(charSequence).convert(this));
        }
        catch (XPathException xPathException) {
            throw new ValidationException(xPathException.getMessage());
        }
    }

    public ItemType getSuperType() {
        if (this == Type.ANY_ATOMIC_TYPE) {
            return AnyItemType.getInstance();
        }
        return (ItemType)((Object)this.getBaseType());
    }

    public int getPrimitiveType() {
        int n = this.getFingerprint();
        if (Type.isPrimitiveType(n)) {
            return n;
        }
        ItemType itemType = this.getSuperType();
        if (itemType instanceof AtomicType) {
            return itemType.getPrimitiveType();
        }
        return this.getFingerprint();
    }

    public AtomicType getAtomizedItemType() {
        return this;
    }

    public String toString() {
        int n = this.getFingerprint();
        if (n < 0) {
            throw new IllegalArgumentException("fingerprint < 0");
        }
        if (n < 1023) {
            return StandardNames.getDisplayName(n);
        }
        return this.getNamePool().getDisplayName(n);
    }

    public boolean isSameType(ItemType itemType) {
        return itemType instanceof AtomicType && ((AtomicType)itemType).getFingerprint() == this.getFingerprint();
    }
}

