/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class DateValue
extends CalendarValue
implements Comparable {
    protected int tzOffset = 0;
    private Date UTCDate = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DateValue;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$net$sf$saxon$value$DateTimeValue;

    protected DateValue() {
    }

    public DateValue(CharSequence charSequence) throws XPathException {
        this.setLexicalValue(charSequence);
    }

    public DateValue(GregorianCalendar gregorianCalendar, boolean bl, int n) {
        this.calendar = gregorianCalendar;
        this.zoneSpecified = bl;
        this.tzOffset = n;
    }

    public void setLexicalValue(CharSequence charSequence) throws XPathException {
        this.zoneSpecified = false;
        StringTokenizer stringTokenizer = new StringTokenizer(Value.trimWhitespace(charSequence).toString(), "-:+Z", true);
        try {
            Object object;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            String string = (String)stringTokenizer.nextElement();
            int n = 1;
            if (string.equals("+")) {
                string = (String)stringTokenizer.nextElement();
            } else if (string.equals("-")) {
                n = -1;
                string = (String)stringTokenizer.nextElement();
            }
            int n2 = Integer.parseInt(string) * n;
            if (string.length() < 4) {
                this.badDate("Year is less than four digits", charSequence);
            }
            if (n2 == 0) {
                this.badDate("Year zero is not allowed", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!stringTokenizer.nextElement().equals("-")) {
                this.badDate("Wrong delimiter after year", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            string = (String)stringTokenizer.nextElement();
            int n3 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badDate("Month must be two digits", charSequence);
            }
            if (n3 < 1 || n3 > 12) {
                this.badDate("Month is out of range", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!stringTokenizer.nextElement().equals("-")) {
                this.badDate("Wrong delimiter after month", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            string = (String)stringTokenizer.nextElement();
            int n4 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badDate("Day must be two digits", charSequence);
            }
            if (n4 < 1 || n4 > 31) {
                this.badDate("Day is out of range", charSequence);
            }
            if (stringTokenizer.hasMoreElements()) {
                object = (String)stringTokenizer.nextElement();
                if (((String)object).equals("Z")) {
                    this.zoneSpecified = true;
                    this.tzOffset = 0;
                    if (stringTokenizer.hasMoreElements()) {
                        this.badDate("Continues after 'Z'", charSequence);
                    }
                } else if (((String)object).equals("+") || ((String)object).equals("-")) {
                    this.zoneSpecified = true;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("Missing timezone", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                    int n5 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("Timezone hour must be two digits", charSequence);
                    }
                    if (n5 > 14) {
                        this.badDate("Timezone hour is out of range", charSequence);
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("No minutes in timezone", charSequence);
                    }
                    if (!stringTokenizer.nextElement().equals(":")) {
                        this.badDate("Wrong delimiter after timezone hour", charSequence);
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("No minutes in timezone", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                    int n6 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("Timezone minute must be two digits", charSequence);
                    }
                    if (n6 > 59) {
                        this.badDate("Timezone minute is out of range", charSequence);
                    }
                    if (stringTokenizer.hasMoreElements()) {
                        this.badDate("Continues after timezone", charSequence);
                    }
                    this.tzOffset = n5 * 60 + n6;
                    if (((String)object).equals("-")) {
                        this.tzOffset = -this.tzOffset;
                    }
                } else {
                    this.badDate("Timezone format is incorrect", charSequence);
                }
            }
            object = new SimpleTimeZone(this.tzOffset * 60000, "LLL");
            this.calendar = new GregorianCalendar((TimeZone)object);
            this.calendar.clear();
            this.calendar.setLenient(false);
            this.calendar.set(Math.abs(n2), n3 - 1, n4);
            this.calendar.set(15, this.tzOffset * 60000);
            this.calendar.set(16, 0);
            if (n2 < 0) {
                this.calendar.set(0, 0);
            }
            try {
                this.calendar.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.badDate("Non-existent date", charSequence);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badDate("Non-numeric component", charSequence);
        }
    }

    private void badDate(String string, CharSequence charSequence) throws XPathException {
        throw new XPathException.Dynamic("Invalid date " + Err.wrap(charSequence, 4) + ". " + string);
    }

    public Date getUTCDate() {
        if (this.UTCDate == null) {
            this.UTCDate = this.calendar.getTime();
        }
        return this.UTCDate;
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 88: 
            case 521: 
            case 643: {
                return this;
            }
            case 519: {
                return new DateTimeValue(this.calendar, this.zoneSpecified);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
            case 523: {
                GYearValue gYearValue = new GYearValue();
                gYearValue.setDateValue(this);
                return gYearValue;
            }
            case 522: {
                GYearMonthValue gYearMonthValue = new GYearMonthValue();
                gYearMonthValue.setDateValue(this);
                return gYearMonthValue;
            }
            case 526: {
                GMonthValue gMonthValue = new GMonthValue();
                gMonthValue.setDateValue(this);
                return gMonthValue;
            }
            case 524: {
                GMonthDayValue gMonthDayValue = new GMonthDayValue();
                gMonthDayValue.setDateValue(this);
                return gMonthDayValue;
            }
            case 525: {
                GDayValue gDayValue = new GDayValue();
                gDayValue.setDateValue(this);
                return gDayValue;
            }
        }
        throw new XPathException.Dynamic("Cannot convert date to " + StandardNames.getDisplayName(n));
    }

    public void setDateValue(DateValue dateValue) {
        this.calendar = dateValue.calendar;
        this.zoneSpecified = dateValue.zoneSpecified;
        this.tzOffset = dateValue.tzOffset;
    }

    public String getStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.calendar.get(0);
        int n2 = this.calendar.get(1);
        if (n == 0) {
            stringBuffer.append('-');
        }
        DateTimeValue.appendString(stringBuffer, n2, n2 > 9999 ? (this.calendar.get(1) + "").length() : 4);
        stringBuffer.append('-');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(2) + 1, 2);
        stringBuffer.append('-');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(5), 2);
        if (this.zoneSpecified) {
            DateTimeValue.appendTimezone(this.tzOffset, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public ItemType getItemType() {
        return Type.DATE_TYPE;
    }

    public CalendarValue removeTimezone() throws XPathException {
        return (CalendarValue)((DateTimeValue)this.convert(519)).removeTimezone().convert(521);
    }

    public CalendarValue setTimezone(SecondsDurationValue secondsDurationValue) throws XPathException {
        return (CalendarValue)((DateTimeValue)this.convert(519)).setTimezone(secondsDurationValue).convert(521);
    }

    public int conversionPreference(Class clazz, Configuration configuration) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DateValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateValue == null ? (class$net$sf$saxon$value$DateValue = DateValue.class$("net.sf.saxon.value.DateValue")) : class$net$sf$saxon$value$DateValue)) {
            return 0;
        }
        if (clazz.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = DateValue.class$("java.util.Date")) : class$java$util$Date)) {
            return 1;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DateValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DateValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 3;
        }
        return super.conversionPreference(clazz, configuration);
    }

    public Object convertToJava(Class clazz, Configuration configuration) throws XPathException {
        if (clazz.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = DateValue.class$("java.util.Date")) : class$java$util$Date)) {
            return this.getUTCDate();
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateTimeValue == null ? (class$net$sf$saxon$value$DateTimeValue = DateValue.class$("net.sf.saxon.value.DateTimeValue")) : class$net$sf$saxon$value$DateTimeValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DateValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DateValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DateValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, configuration);
        if (object == null) {
            throw new XPathException.Dynamic("Conversion of date to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 1: {
                return new IntegerValue(this.calendar.get(1));
            }
            case 2: {
                return new IntegerValue(this.calendar.get(2) + 1);
            }
            case 3: {
                return new IntegerValue(this.calendar.get(5));
            }
            case 7: {
                if (this.zoneSpecified) {
                    return SecondsDurationValue.fromMilliseconds(this.tzOffset * 60000);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for date: " + n);
    }

    public int compareTo(Object object) {
        if (!(object instanceof DateValue)) {
            throw new ClassCastException("Date values are not comparable to " + object.getClass());
        }
        int n = this.getUTCDate().compareTo(((DateValue)object).getUTCDate());
        if (n == 0) {
            return ((DateValue)object).tzOffset - this.tzOffset;
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getUTCDate().hashCode() + new Integer(this.tzOffset).hashCode();
    }

    public CalendarValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            int n = (int)durationValue.getLengthInSeconds() / 86400;
            GregorianCalendar gregorianCalendar = (GregorianCalendar)this.calendar.clone();
            gregorianCalendar.add(5, n);
            return new DateValue(gregorianCalendar, this.zoneSpecified, this.tzOffset);
        }
        if (durationValue instanceof MonthDurationValue) {
            int n = ((MonthDurationValue)durationValue).getLengthInMonths();
            GregorianCalendar gregorianCalendar = (GregorianCalendar)this.calendar.clone();
            gregorianCalendar.add(2, n);
            return new DateValue(gregorianCalendar, this.zoneSpecified, this.tzOffset);
        }
        throw new XPathException.Type("Date arithmetic is not supported on xs:duration, only on its subtypes");
    }

    public SecondsDurationValue subtract(CalendarValue calendarValue) throws XPathException {
        if (!(calendarValue instanceof DateValue)) {
            throw new XPathException.Type("First operand of '-' is a date, but the second is not");
        }
        return super.subtract(calendarValue);
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "date (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

