/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class SecondsDurationValue
extends DurationValue {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DurationValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;

    private SecondsDurationValue() {
    }

    public SecondsDurationValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(Value.trimWhitespace(charSequence).toString(), "-+.PDTHMS", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).equals("+")) {
                string = (String)stringTokenizer.nextElement();
            } else if (string.equals("-")) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!string.equals("P")) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if (string.equals("T")) {
                    n = 4;
                    string = (String)stringTokenizer.nextElement();
                }
                int n2 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'D': {
                        if (n > 2) {
                            this.badDuration("D is out of sequence", charSequence);
                        }
                        this.days = n2;
                        n = 3;
                        break;
                    }
                    case 'H': {
                        if (n != 4) {
                            this.badDuration("H is out of sequence", charSequence);
                        }
                        this.hours = n2;
                        n = 5;
                        break;
                    }
                    case 'M': {
                        if (n < 4 || n > 5) {
                            this.badDuration("M is out of sequence", charSequence);
                        }
                        this.minutes = n2;
                        n = 6;
                        break;
                    }
                    case '.': {
                        if (n > 6) {
                            this.badDuration("misplaced decimal point", charSequence);
                        }
                        this.seconds = n2;
                        n = 7;
                        break;
                    }
                    case 'S': {
                        if (n > 7) {
                            this.badDuration("S is out of sequence", charSequence);
                        }
                        if (n == 7) {
                            while (string.length() < 3) {
                                string = string + "0";
                            }
                            if (string.length() > 3) {
                                string = string.substring(0, 3);
                            }
                            this.milliseconds = Integer.parseInt(string);
                        } else {
                            this.seconds = n2;
                        }
                        n = 8;
                        break;
                    }
                    default: {
                        this.badDuration("misplaced " + c, charSequence);
                    }
                }
            }
            this.normalize();
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric or out-of-range component", charSequence);
        }
    }

    public String getStringValue() {
        double d = this.getLengthInSeconds();
        if (d < 0.0) {
            d = -d;
        }
        long l = (long)Math.floor(d);
        int n = (int)(d % 1.0 * 1000.0);
        long l2 = l % 60L;
        long l3 = l / 60L;
        long l4 = l3 / 60L;
        l3 %= 60L;
        long l5 = l4 / 24L;
        l4 %= 24L;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.negative) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (l5 != 0L) {
            stringBuffer.append(l5);
            stringBuffer.append('D');
        }
        if (l5 == 0L || l4 != 0L || l3 != 0L || l2 != 0L || n != 0) {
            stringBuffer.append('T');
        }
        if (l4 != 0L) {
            stringBuffer.append(l4);
            stringBuffer.append('H');
        }
        if (l3 != 0L) {
            stringBuffer.append(l3);
            stringBuffer.append('M');
        }
        if (l2 != 0L || n != 0 || l5 == 0L && l3 == 0L && l4 == 0L) {
            stringBuffer.append(l2);
            if (this.milliseconds != 0) {
                stringBuffer.append('.');
                DateTimeValue.appendString(stringBuffer, n, 3);
            }
            stringBuffer.append('S');
        }
        return stringBuffer.toString();
    }

    public void normalize() throws XPathException.Dynamic {
        long l = this.seconds;
        long l2 = this.minutes;
        long l3 = this.hours;
        long l4 = this.days;
        if (this.milliseconds >= 1000) {
            l += (long)(this.milliseconds / 1000);
            this.milliseconds %= 1000;
        }
        if (this.seconds >= 60) {
            l2 += l / 60L;
            l = (int)(l % 60L);
        }
        if (l2 >= 60L) {
            l3 += l2 / 60L;
            l2 = (int)(l2 % 60L);
        }
        if (l3 >= 24L) {
            if ((l4 += l3 / 24L) > Integer.MAX_VALUE || l4 < Integer.MIN_VALUE) {
                throw new XPathException.Dynamic("Duration exceeds implementation-defined limits");
            }
            l4 = (int)l4;
            l3 = (int)(l3 % 24L);
        }
        this.days = (int)l4;
        this.hours = (int)l3;
        this.minutes = (int)l2;
        this.seconds = (int)l;
    }

    public double getLengthInSeconds() {
        double d = this.days;
        d = d * 24.0 + (double)this.hours;
        d = d * 60.0 + (double)this.minutes;
        d = d * 60.0 + (double)this.seconds;
        return this.negative ? -d : (d += (double)this.milliseconds / 1000.0);
    }

    public long getLengthInMilliseconds() {
        long l = this.days;
        l = l * 24L + (long)this.hours;
        l = l * 60L + (long)this.minutes;
        l = l * 60L + (long)this.seconds;
        l = l * 1000L + (long)this.milliseconds;
        return this.negative ? -l : l;
    }

    public static SecondsDurationValue fromSeconds(double d) throws XPathException {
        SecondsDurationValue secondsDurationValue = new SecondsDurationValue();
        secondsDurationValue.negative = d < 0.0;
        secondsDurationValue.seconds = (int)(d < 0.0 ? -d : d);
        secondsDurationValue.milliseconds = (int)(d % 1.0 * 1000.0);
        secondsDurationValue.normalize();
        return secondsDurationValue;
    }

    public static SecondsDurationValue fromMilliseconds(long l) throws XPathException {
        SecondsDurationValue secondsDurationValue = new SecondsDurationValue();
        secondsDurationValue.negative = l < 0L;
        long l2 = Math.abs(l) / 1000L;
        secondsDurationValue.days = (int)(l2 / 86400L);
        secondsDurationValue.seconds = (int)(l2 % 86400L);
        secondsDurationValue.milliseconds = (int)(l % 1000L);
        secondsDurationValue.normalize();
        return secondsDurationValue;
    }

    public DurationValue multiply(double d) throws XPathException {
        return SecondsDurationValue.fromMilliseconds((long)((double)this.getLengthInMilliseconds() * d));
    }

    public DoubleValue divide(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            long l = this.getLengthInMilliseconds();
            long l2 = ((SecondsDurationValue)durationValue).getLengthInMilliseconds();
            long l3 = 1L;
            while ((l & l3) == 0L && (l2 & l3) == 0L && l != 0L && l2 != 0L) {
                l /= 2L;
                l2 /= 2L;
            }
            return new DoubleValue((double)l / (double)l2);
        }
        throw new XPathException.Dynamic("Cannot divide two durations of different type");
    }

    public DurationValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            return SecondsDurationValue.fromMilliseconds(this.getLengthInMilliseconds() + ((SecondsDurationValue)durationValue).getLengthInMilliseconds());
        }
        throw new XPathException.Dynamic("Cannot add two durations of different type");
    }

    public DurationValue subtract(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            return SecondsDurationValue.fromMilliseconds(this.getLengthInMilliseconds() - ((SecondsDurationValue)durationValue).getLengthInMilliseconds());
        }
        throw new XPathException.Dynamic("Cannot add two durations of different type");
    }

    public ItemType getItemType() {
        return Type.DAY_TIME_DURATION_TYPE;
    }

    public int conversionPreference(Class clazz, Configuration configuration) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SecondsDurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = SecondsDurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return 0;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = SecondsDurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = SecondsDurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz, Configuration configuration) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = SecondsDurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = SecondsDurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = SecondsDurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SecondsDurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        throw new XPathException.Dynamic("Conversion of dayTimeDuration to " + clazz.getName() + " is not supported");
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "dayTimeDuration (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

