/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class Expression
implements Serializable {
    protected SourceLocator m_slocator;

    public DTMIterator asIterator(XPathContext xPathContext, int n) throws TransformerException {
        try {
            xPathContext.pushCurrentNodeAndExpression(n, n);
            DTMIterator dTMIterator = this.execute(xPathContext).iter();
            Object var5_4 = null;
            xPathContext.popCurrentNodeAndExpression();
            return dTMIterator;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            xPathContext.popCurrentNodeAndExpression();
            throw throwable;
        }
    }

    public int asNode(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext).iter().nextNode();
    }

    public void assertion(boolean bl, String string) throws TransformerException {
        if (!bl) {
            String string2 = XSLMessages.createXPATHMessage(30, new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    public boolean bool(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext).bool();
    }

    public boolean canTraverseOutsideSubtree() {
        return false;
    }

    public void error(XPathContext xPathContext, int n, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        if (xPathContext != null) {
            ErrorListener errorListener = xPathContext.getErrorListener();
            TransformerException transformerException = new TransformerException(string, this.m_slocator);
            errorListener.fatalError(transformerException);
        }
    }

    public abstract XObject execute(XPathContext var1) throws TransformerException;

    public XObject execute(XPathContext xPathContext, int n) throws TransformerException {
        return this.execute(xPathContext);
    }

    public XObject execute(XPathContext xPathContext, int n, DTM dTM, int n2) throws TransformerException {
        return this.execute(xPathContext);
    }

    public void executeCharsToContentHandler(XPathContext xPathContext, ContentHandler contentHandler) throws TransformerException, SAXException {
        XObject xObject = this.execute(xPathContext);
        xObject.dispatchCharactersEvents(contentHandler);
    }

    public abstract void fixupVariables(Vector var1, int var2);

    public boolean isNodesetExpr() {
        return false;
    }

    public boolean isStableNumber() {
        return false;
    }

    public double num(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext).num();
    }

    public void setSourceLocator(SourceLocator sourceLocator) {
        this.m_slocator = sourceLocator;
    }

    public void warn(XPathContext xPathContext, int n, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHWarning(n, objectArray);
        if (xPathContext != null) {
            ErrorListener errorListener = xPathContext.getErrorListener();
            errorListener.warning(new TransformerException(string, xPathContext.getSAXLocator()));
        }
    }

    public XMLString xstr(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext).xstr();
    }
}

