<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="2.0"
    xmlns:lxslt="http://xml.apache.org/xslt">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
  <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
  <xsl:variable name="DashboardDir" select="concat('../../../../Dashboard/', $DashboardStamp)"/>
  <xsl:param name="TestDocDir">.</xsl:param>
  <xsl:include href="DashboardConfig.xsl"/>
  <xsl:output method="html"/>
  <xsl:template match="/">
    <xsl:call-template name="Summary"/>
    <xsl:call-template name="DynamicAnalysis"/>
  </xsl:template>

  <xsl:template name="DynamicAnalysis">
      <xsl:call-template name="DashboardHeader">
        <xsl:with-param name="Title">DynamicAnalysis <xsl:value-of select="Site/@Name"/> -- <xsl:value-of select="Site/@BuildName"/></xsl:with-param>
        <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
        <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
      </xsl:call-template>
     <p><b><xsl:text>Site:</xsl:text></b><xsl:value-of select="Site/@Name"/></p>
     <p>
       <b>
         <xsl:text>Build Name:</xsl:text>
       </b>
       <xsl:value-of select="Site/@BuildName"/>
     </p>

    <table cellspacing="0">
      <tr>
        <th>Name</th>
        <th>Status</th>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></th>
        <xsl:for-each select="Site/DynamicAnalysis/DefectList/Defect">
          <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <xsl:value-of select="@Type"/>
              <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
          </th>
        </xsl:for-each>
      </tr>

      <xsl:variable name="DefectList" select="/Site/DynamicAnalysis/DefectList"/>
      <xsl:for-each select="Site/DynamicAnalysis/Test">
        <xsl:sort select="sum(Results/Defect) > 0" order="descending"/>
        <xsl:sort select="Name"/>

         <xsl:call-template name="Test"/>
         <tr align="center">
          <xsl:if test="position() mod 2 = 0">
            <xsl:attribute name="bgcolor"><xsl:value-of select="$LightBlue"/></xsl:attribute>
          </xsl:if>
          <td align="left">
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix">DynamicAnalysis/</xsl:with-param>
                  <xsl:with-param name="TestName" select="FullName"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:call-template name="SoftHyphenStringAtSlash">
                <xsl:with-param name="src">
                  <xsl:value-of select="Name"/>
                </xsl:with-param>
              </xsl:call-template>
            </a>
          </td>
          <td>
            <xsl:choose>
              <xsl:when test="contains('passed',@Status)">
                <xsl:attribute name="bgcolor"><xsl:value-of select="$NormalColor"/></xsl:attribute>
                Passed
              </xsl:when>
              <xsl:when test="contains('failed',@Status)">
                <xsl:attribute name="bgcolor"><xsl:value-of select="$WarningColor"/></xsl:attribute>
                Failed
              </xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="bgcolor"><xsl:value-of select="$ErrorColor"/></xsl:attribute>
                Not Run
              </xsl:otherwise>
            </xsl:choose>
          </td>
        <td><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
        <xsl:variable name="CurrentTest" select="."/>
        <xsl:for-each select="$DefectList/Defect">
          <td>
          <xsl:variable name="DefectType" select="@Type"/>
          <xsl:for-each select="$CurrentTest/Results/Defect">
             <xsl:if test="@type = $DefectType">
                <xsl:if test=". &gt; 0">
                  <xsl:attribute name="bgcolor">
                    <xsl:value-of select="$WarningColor"/>
                  </xsl:attribute>
                </xsl:if>
                <xsl:value-of select="."/>
             </xsl:if>
          </xsl:for-each>
          </td>
          </xsl:for-each>
        </tr>
      </xsl:for-each>
    </table>

    <xsl:call-template name="DashboardFooter">
        <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
    </xsl:call-template>

  </xsl:template>


   <xsl:template name="Test">
     <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/DynamicAnalysis/', translate ( FullName, '/.', '__' ) , '.html' )"/>
     <xsl:result-document href="{$uri}" >
       <xsl:call-template name="DashboardHeader">
         <xsl:with-param name="Title"><xsl:value-of select="DynamicAnalysis/Checker"/> results for <xsl:value-of select="Name"/></xsl:with-param>
         <xsl:with-param name="IconDir">../../../../../Icons</xsl:with-param>
         <xsl:with-param name="DashboardDir">../<xsl:value-of select="$DashboardDir"/></xsl:with-param>
       </xsl:call-template>
       <p>
         <b>Site Name: </b> <xsl:value-of select="/Site/@Name"/>
       </p>
       <p>
         <b>Build Name: </b> <xsl:value-of select="/Site/@BuildName"/>
       </p>
       <a>
         <xsl:attribute name="href">
           <xsl:call-template name="TranslateTestName">
             <xsl:with-param name="Prefix">../<xsl:value-of select="$DashboardDir"/>/TestDetail/</xsl:with-param>
             <xsl:with-param name="TestName" select="FullName"/>
             <xsl:with-param name="Postfix">.html</xsl:with-param>
           </xsl:call-template>
         </xsl:attribute>
         <xsl:value-of select="Name"/>
       </a>
       <xsl:choose>
         <xsl:when test="contains('failed',@Status)">
           <font>
             <xsl:attribute name="color"><xsl:value-of select="$WarningColor"/></xsl:attribute>
             Failed
           </font>
         </xsl:when>
         <xsl:when test="contains('passed',@Status)">
           <font>
             <xsl:attribute name="color"><xsl:value-of select="$NormalColor"/></xsl:attribute>
             Passed
           </font>
         </xsl:when>
       </xsl:choose>

       <pre>
         <xsl:value-of select="Log" disable-output-escaping="yes"/>
       </pre>

       <xsl:call-template name="DashboardFooter">
         <xsl:with-param name="IconDir">../../../../../Icons</xsl:with-param>
       </xsl:call-template>
     </xsl:result-document>
   </xsl:template>



<xsl:template name="Summary">
  <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/DynamicAnalysisSummary.xml' )"/>
  <xsl:result-document href="{$uri}" >
    <DynamicAnalysis>
      <Checker><xsl:value-of select="Site/DynamicAnalysis/@Checker"/></Checker>
      <SiteName><xsl:value-of select="Site/@Name"/></SiteName>
      <BuildName><xsl:value-of select="Site/@BuildName"/></BuildName>
      <BuildStamp><xsl:value-of select="Site/@BuildStamp"/></BuildStamp>
      <StartDateTime><xsl:value-of select="Site/DynamicAnalysis/StartDateTime"/></StartDateTime>

      <DefectCount><xsl:value-of select="sum(Site/DynamicAnalysis/Test/Results/Defect)"/></DefectCount>
      <EndDateTime><xsl:value-of select="Site/DynamicAnalysis/EndDateTime"/></EndDateTime>
    </DynamicAnalysis>
  </xsl:result-document>
</xsl:template>

</xsl:stylesheet>
