/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "datatableinterface.h"

void Watched::addObserver( DataTableObserver *observer )
{
    m_observers.append( observer );
}

void Watched::removeObserver( DataTableObserver *observer )
{
    m_observers.remove( observer );
}

Watched::~Watched()
{
    for ( QValueList<DataTableObserver *>::Iterator it = m_observers.begin();
            it != m_observers.end();
            ++it )
    {
        ( *it ) ->clearWatched();
    }
}

DataTableObserver::~DataTableObserver()
{
    if ( m_dataTable )
        m_dataTable->removeObserver( this );
}

DataTableObserver::DataTableObserver( DataTableInterface *dataTable ) :
        m_dataTable( dataTable )
{
    dataTable->addObserver( this );
}

const DataTableInterface *DataTableObserver::dataTable() const
{
    return m_dataTable;
}
