/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STATUSLABEL_H
#define STATUSLABEL_H

#include "datatableinterface.h"
#include <qlabel.h>
#include <ksqueezedtextlabel.h>
#include <qhbox.h>

class QLabel;
class KSqueezedTextLabel;

class StatusLabel : public QHBox, public DataTableObserver
{
    Q_OBJECT

public:
    StatusLabel( DataTableInterface *dataTable, QWidget *parent = 0, const char *name = 0 );
    virtual ~StatusLabel();

public slots:
    void setLeft( const QString &text )
    {
        m_left->setText( text );
    };
    void setRight( const QString &text )
    {
        m_right->setText( text );
    };
    void setFarRight( const QString &text )
    {
        m_farRight->setText( text );
    };

private:
    KSqueezedTextLabel *m_left;
    KSqueezedTextLabel *m_right;
    QLabel *m_farRight;
};

#endif
