#ifndef CLIENT_NOTIFIER_H__
#define CLIENT_NOTIFIER_H__

#include <string>

#include <dcpp/stdinc.h>
#include <dcpp/DCPlusPlus.h>
#include <dcpp/Client.h>
#include <dcpp/ClientManager.h>
#include <dcpp/User.h>
#include <dcpp/SearchManager.h>
#include <dcpp/UploadManager.h>
#include <dcpp/DownloadManager.h>
#include "dcpp/DirectoryListing.h"

#include <list>
#include <vector>
#include "TransferManager.h"
#include <rpcdriver.h>

class FavoriteHubEntry;

using namespace std;

namespace dcqt_backend
{

//! Lightweight abstraction layer between a Session and the XmlRpcClient
class ClientNotifier
{
 public:
  enum TransferEvent {STARTING=0,TICK=1,COMPLETE=2,FAILED=3};
  enum QueueEvent {QUEUE_ADD=1,QUEUE_REMOVE,QUEUE_FINISH,QUEUE_SOURCE_UPDATE,QUEUE_STATUS_UPDATE};

  enum {UPLOAD=0,DOWNLOAD=1};
  virtual void connected(int aSessionId);
  virtual void connectionFailed(int session,const string& reason);
  virtual void hubUpdated(int aSessionId,const std::string& hubName);
  virtual void message(int aSessionId,const std::string& msg);
  virtual void userUpdated(int aSessionId,const ::User::Ptr& user);
  //virtual void usersUpdated(int aSessionId, const ::User::List &list);
  virtual void usersUpdated(int sessionId, const vector<int>& updatedUsers);
  virtual void userRemoved(int aSessionId,int aUserId);
  virtual void hashInfo(string&,int64_t,int,int);
  virtual void privateMessage(int aSessionId,const ::User::Ptr& user,const std::string& msg);
  virtual void searchResult(int aSessionId, SearchResult* result);
  virtual void searchResults(int aSessionId, vector<SearchResult*>& results);
  virtual void getPassword(int aSessionId);
  virtual void hubStats(int aSessionId,int64_t aAvailable);
  
  //! Starting or complete
  virtual void transferEvent(TransferEvent e,Upload*);
  //! Failed
  virtual void transferEvent(Upload*,const string&);
  virtual void transferTick(const Upload::List&,TransferManager::UploadStatusMap&);
  virtual void transferEvent(TransferEvent e,Download*);
  virtual void transferEvent(Download*,const string&);
  virtual void transferTick(const Download::List&);
  
  virtual void queueEvent(QueueEvent event,QueueItem*,int);

  // Added
  virtual void finishedEvent(int type,int,FinishedItem*);
  // Removed
  virtual void finishedEvent(int type,int id);
  // RemovedAll
  virtual void finishedEvent(int type);

    virtual void newHubList();

    virtual void favouriteHubAdded(const FavoriteHubEntry* e);
    virtual void favouriteHubRemoved(const string& server);

  static ClientNotifier* instance() {if(!inst) inst = new ClientNotifier;return inst;}

	void setRpcDriver(rpc::RpcDriverPtr aDriver) {driver=aDriver;}

protected:
     ClientNotifier() {}
     static ClientNotifier* inst;
 
	 string createFileListing( QueueItem* item );
	 void parseDir( DirectoryListing::Directory::Ptr dir, std::string& tree, bool isUtf8 );
	 rpc::RpcDriverPtr driver;
};
}

#endif
