/* Distributed Checksum Clearinghouse
 *
 * autoconf configuration settings
 *	modified for WIN32
 * Run ./configure on UNIX-like systems
 *
 * Copyright (c) 2005 by Rhyolite Software, LLC
 *
 * This agreement is not applicable to any entity which sells anti-spam
 * solutions to others or provides an anti-spam solution as part of a
 * security solution sold to other entities, or to a private network
 * which employs the DCC or uses data provided by operation of the DCC
 * but does not provide corresponding data to other users.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * Parties not eligible to receive a license under this agreement can
 * obtain a commercial license to use DCC and permission to use
 * U.S. Patent 6,330,590 by contacting Commtouch at http://www.commtouch.com/
 * or by email to nospam@commtouch.com.
 *
 * A commercial license would be for Distributed Checksum and Reputation
 * Clearinghouse software.  That software includes additional features.  This
 * free license for Distributed ChecksumClearinghouse Software does not in any
 * way grant permision to use Distributed Checksum and Reputation Clearinghouse
 * software
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE, LLC DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE, LLC
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.3.42-1.95 $Revision$
 * @configure_input@
 */

#ifndef DCC_CONFIG_H
#define DCC_CONFIG_H

#undef UNIX
#define DCC_WIN32 1

#define DCC_HOMEDIR "c:\\Program Files\\DCC"
#undef DCC_LIBEXECDIR
#define DCC_RUNDIR	"/var/run/dcc"

/* use kludge file if asked */
#undef NEED_KLUDGE_H

/* use external filter */
#undef USE_XFLTR

/* deal with systems such as Solaris that do not have a __P() macro
 *	assume they understand prototypes */
#define HAVE_SYS_CDEFS_H 1
#if !defined(HAVE_SYS_CDEFS_H) && !defined(__P)
#define __P(protos) protos
#endif

/* some systems have uint32_t, others have u_int32_t, and some have both */
#define DCC_HAVE_U_INT32_T 1
/* and then there is u_*int64_t */
#define DCC_HAVE_U_INT64_T 1

/* 64-bit long int */
#undef HAVE_64BIT_LONG

/* ./configure does not check for pid_t on the grounds that only WIN32
 * lacks it, and Windows is handled by the genbundle script */
#undef HAVE_PID_T

/* build the client library to work around Solaris broken fcntl() NFS locking */
#define BAD_FCNTL_LOCKS 1

/* turn off dccifd AF_UNIX sockets on HP-UX */
#undef HP_UX_BAD_AF_UNIX

/* Use poll() instead of select() on Solaris and some other systems
 * because socket() can yield file descripters larger than FD_SETSIZE. */
#undef HAVE_POLL
#undef USE_POLL

/* number of cached open per-user whitelist files */
#define NUM_CWFS 20

#define TIME_WITH_SYS_TIME 1
#undef HAVE_UTIME_H
#undef HAVE_FUTIMES

#undef HAVE_SETPGID

#undef HAVE_GCC_ATTRIBUTES
#undef HAVE_GCC_INLINE
#undef USE_VA_COPY

/* fill holes in the target */
#undef HAVE_DAEMON
#undef HAVE_VSYSLOG
#undef HAVE_HSTRERROR
#undef HAVE_INET_NTOP
#undef HAVE_GETHOSTID
#undef HAVE_LOCALTIME_R
#define HAVE_TIMEGM 1
#undef HAVE_ALTZONE

#undef NEED_STRINGS_H
#undef HAVE_STRLCPY
#undef HAVE_STRLCAT

/* A way to get the size of physical memory
 *  Linux and Solaris have sysconf(_SC_PHYS_PAGES)
 *  BSD systems have sysctl(HW_PHYSMEM)
 *  HP-UX has pstat_getstatic() */
#undef HAVE_PHYSMEM_TOTAL
#undef HAVE__SC_PHYS_PAGES
#define HAVE_HW_PHYSMEM 1
#undef HAVE_PSTAT_GETSTATIC
#define GOT_PHYSMEM 1
/* use `dbclean -F` on Solaris to force less unneeded disk I/O */
#undef USE_DBCLEAN_F

/* 0 or minimum size of server database buffer or window */
#define DCC_MIN_DB_MBYTE 0
/* 0 or maximum size of server database buffer */
#define DCC_MAX_DB_MBYTE 2020


/* 4.4BSD sockets */
#undef HAVE_SA_LEN
#undef HAVE_SOCKLEN_T
#undef HAVE_AF_LOCAL

#undef HAVE_INET_ATON

#define HAVE_GETIPNODEBYNAME 1
#define HAVE_GETIPNODEBYADDR 1
#define HAVE_FREEHOSTENT 1

#define HAVE_GETADDRINFO 1
#define HAVE_GETNAMEINFO 1
#define HAVE_FREEADDRINFO 1
#define HAVE_GAI_STRERROR 1

#define NO_IPV6 1
#undef NO_AF_INET6
#define CONF_S6_ADDR32 __u6_addr.__u6_addr32

/* use getifaddrs() to get list of interface addresses */
#define HAVE_GETIFADDRS 1
#undef USE_DCC_GETIFADDRS
/* Some systems have getifaddrs() but not freeifaddrs() */
#define HAVE_FREEIFADDRS 1

/* BIND resolver library */
#undef HAVE_RESOLV_H
#undef HAVE_ARPA_NAMESER_H
#undef HAVE__RES
#define HAVE_RES_INIT 1
#define HAVE_RES_QUERY 1
#define HAVE_DN_EXPAND 1

/* Solaris and WIN32 do not have paths.h */
#undef HAVE_PATHS_H

/* Some systems have their own MD5 libraries */
#undef HAVE_MD5

#undef HAVE_PTHREADS

/* HP_UX has sys/pthread.h instead of pthread.h */
#define HAVE_PTHREAD_H 1

/* Windows systems lack UNIX permission bits */
#undef HAVE_PRIVATE_FILES

/* files with 64-bit offsets */
#undef HAVE_BIG_FILES

/* __progname defined by crt0 and so a reasonable default for syslog */
#undef HAVE___PROGNAME
/* slightly more portable way to get the program name */
#undef HAVE_GETPROGNAME

/* very old BSD/OS has only 2 parameters for msync()
 * and newer versions ignore the third parameter */
#undef HAVE_OLD_MSYNC

/* use SOCKS */
#undef HAVE_RSENDTO

/* save only this much of mail messages in dccm and dccifd log files */
#define MAX_LOG_SIZE 32768


#endif /* DCC_CONFIG_H */
